import React, { Component } from 'react'; import PropTypes from 'prop-types';
import { Radio, Select, DatePicker, Input } from 'amos-antd';
import moment from 'moment';

const Option = Select.Option;
const RadioButton = Radio.Button;
const RadioGroup = Radio.Group;

/**
 * 单属性筛选
 * @class PropsFilter
 * @extends {Component}
 */
class PropsFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      count: 1,
      filterValue: '',
      textValue: '',
      listValue: '全部'
    };
    this.textChange = this.textChange.bind(this);
    this.radioChange = this.radioChange.bind(this);
    this.selectChange = this.selectChange.bind(this);
  }

  componentWillReceiveProps(nextProps) {
    let type = nextProps.st;
    if (type === 'text'){
      let textValue = nextProps.defaultValue;
      let count = this.state.count;
      if (count === 1 && textValue && textValue !== ''){
        this.setState({ textValue,count: 0 });
      }
    }
    if (type === 'list'){
      let listValue = nextProps.defaultValue;
      let count = this.state.count;
      if (count === 1 && listValue && listValue !== ''){
        this.setState({ listValue,count: 0 });
      }
    }
  }

  textChange(e){
    this.setState({ textValue: e.target.value });
    this.props.changeFilters(this.props.dataIndex,e.target.value);
  }

  radioChange(e){
    this.props.changeFilters(this.props.dataIndex,e.target.value);
  }

  selectChange(value){
    this.setState({ listValue: value });
    this.props.changeFilters(this.props.dataIndex,value);
  }

  dateChange = (value) => {
    this.props.changeFilters(this.props.dataIndex,value);
  }

  selectTypeFilter = () => {
    const { st } = this.props;
    switch (st)
    {
      case 'text':
        return this.textContent();
      case 'list':
        return this.listContent();
      case 'date':
        return this.dateContent();
      case 'redio':
        return this.redioContent();
    }
  }

  textContent = () => {
    return (
      <Input id='filterValue' value={this.state.textValue} className='amos-filter-text' onChange={this.textChange} name='filterValue' />
    );
  }

  dateContent = () => {
    return (
      <DatePicker className='amos-filter-date' format="YYYY-MM-DD HH:mm:ss" showTime={{ defaultValue: moment('00:00:00', 'HH:mm:ss') }} onChange={this.dateChange} name='filterValue' id='filterValue' />
    );
  }

  listContent = () => {
    let { list } = this.props;
    let listValue = this.state.listValue;
    return (
      <Select allowClear showSearch optionFilterProp="children" onChange={this.selectChange} value={listValue}  className='amos-filter-list' dropdownStyle={{ maxHeight: '110px',overflow: 'overlay' }} >
        <Option key='all' value='全部'>全部</Option>
        {
          list.map(e=>(
            <Option key={e.value} value={e.value}>{e.name}</Option>
          ))
        }
      </Select>
    );
  }

  redioContent = () => {
    let { list } = this.props;
    return (
      <RadioGroup onChange={this.radioChange} defaultValue='全部'  className='amos-filter-redio' >
        <RadioButton value='全部'>全部</RadioButton>
        {
          list.map(e=>(
            <RadioButton key={e} value={e}>{e}</RadioButton>
          ))
        }
      </RadioGroup>
    );
  }

  render() {
    let { title } = this.props;
    return (
      <li className='amos-table-filter-li'>
        <span className='amos-prop-filter'>{title}</span>
        <span className='amos-filter-value'>
          {this.selectTypeFilter()}
        </span>
      </li>
    );
  }
}

PropsFilter.propTypes = {
  title: PropTypes.string,
  st: PropTypes.string,
  list: PropTypes.array,
  changeFilters: PropTypes.func,
  dataIndex: PropTypes.string
};

PropsFilter.defaultProps = {
  list: [],
  allFilter: []
};

export default PropsFilter;
