import React, { Component } from 'react'; import PropTypes from 'prop-types';
import PropFilter from './PropFilter';

class TableFilter extends Component {
  constructor(props) {
    super(props);
    this.state = {
      filters: []
    };
  }

  componentWillMount() {
    let { columns,changeFilters } = this.props;
    let res = this.addFilter(columns,changeFilters);
    this.setState({ filters: res });
  }

  componentWillReceiveProps(nextProps) {
    let { columns,changeFilters } = nextProps;
    let res = this.addFilter(columns,changeFilters);
    this.setState({ filters: res });
  }

  addFilter= (columns,changeFilters) => {
    let res = [];
    columns.map((e,index)=>{
      res.push(<PropFilter key={index} changeFilters={this.props.changeFilters} {...e} />);
    });
    return res;
  }

  render() {
    return (
      <ul className='amos-table-filter'>
        {
          this.state.filters
        }
      </ul>
    );
  }
}

TableFilter.propTypes = {
  columns: PropTypes.array,
  changeFilters: PropTypes.func
};

export default TableFilter;
