import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'amos-react-router';
import Icon from 'amos-icon';

class Search extends Component {

  static propTypes = {
    placeholder: PropTypes.string,
    to: PropTypes.string
  };

  render() {

    const { placeholder, to } = this.props;

    return (
      <Link to={to}>
        <div className="tip-search">
          <Icon icon="search" />
          <input className="tip-srh-ipt" placeholder="" />
          <span>{placeholder}</span>
        </div>
      </Link>
    );
  }
}

export default Search;
