import { trim } from 'amos-tool';
/**
 * 文本输入框的字符输入长度限制
 * length 限制的长度
 *
 * rules: [{ validator: textLengthValidate(20) } ] 长度不能大于20
 * rules: [{ validator: textLengthValidate(20,1) } ] 长度不能大于20 长度不能小于1
 */
export const textLengthValidate = (maxLength, minLength) => {
  return (rule, value, callback) => {
    if (value){
      if (trim(value).length > maxLength){
        callback(`长度不能大于${maxLength}`);
      } else {
        if (minLength && trim(value).length < minLength){
          callback(`长度不能小于${minLength}`);
        } else {
          callback();
        }
      }
    }
    callback();
  };
};


/**
 * 字段长度校验
 * @param {*} maxLength 
 * @param {*} isRequired 是否必填 
 * @param {*} message 提示消息 
 */
export const noSpaceLengthValidate = (maxLength,isRequired,message) => {
  return (rule, value, callback) => {
    if (value){
      let lengthSize = trim(value).length 
      if(isRequired){
        if(lengthSize === 0 ){
          callback(message);
        }
        if (maxLength && lengthSize>= maxLength){
          callback(`长度范围为${maxLength}！`);
        }
      }else{
        if (maxLength && lengthSize>= maxLength){
          callback(`长度范围为${maxLength}！`);
        }
      } 
    }
    callback();
  };
};


/**
 * 对象中的字符串属性进行trim
 */
export const objOfStrPropTrim = (values) => {
  if (typeof values === 'object'){
    let keys = Object.keys(values);
    keys.forEach(e=>{
      if (typeof values[e] === 'string'){
        values[e] = trim(values[e]);
      }
    });
  }
  return values;
};

/**
 * 對輸入的數字進行最大值和最小值的限制
 */
export const textValueValidate = (maxValue,minValue) => {
  return (rule, value, callback) => {
    if (value){
      if (/^-?\d+\.?\d*$/.test(value)){
        if (value > maxValue){
          callback(`输入的值不能大于${maxValue}`);
        } else {
          if (minValue && minValue < maxValue && value < minValue){
            callback(`输入的值不能小于${minValue}`);
          } else {
            callback();
          }
        }
      } else {
        callback('请输入正确的数值格式');
      }
    }
    callback();
  };
};

/**
 * 限制输入的第一位数不能为0
 */
export const textFirstValueValidate = (minLength) => {
  return (rule, value, callback) => {
    if (value){
      if (/^[1-9]\d*$/.test(value)){
        if (minLength && trim(value).length < minLength){
          callback(`长度不能小于${minLength}`);
        }
      } else {
        callback('输入的值第一位不能为0');
      }
    }
    callback();
  };
};

/**
 * 限制输入的值为数字且不能小于0
 */
export const textIsNumValidate = (minValue) => {
  return (rule, value, callback) => {
    if (value){
      if (/^-?\d+\.?\d*$/.test(value)){
        if (minValue && value < minValue){
          callback(`输入的值不能小于${minValue}`);
        } else {
          callback();
        }
      } else {
        callback('只能输入数字');
      }
    }
    callback();
  };
};

/**
 * 不能输入空格
 */
export const notAllSpaceValidate = (message) => {
  return (rule, value, callback) => {
    if (value){
      if (trim(value).length === 0){
        callback(message);
      }
    }
    callback();
  };
};
