import React, { Component } from 'react';
import PropTypes from 'prop-types';
import GridButton from './../../common/btns/GridButton';
import SimpleModal from './../../common/modal/SimpleModal';
import CompanyAddEdit from './CompanyAddEdit';
import {objOfStrPropTrim} from './../../common/utils/validate';
import {Form} from 'amos-antd';
const createForm = Form.create();
const dataToTree = (dataList = []) => {
  dataList.map((data)=>{
    data.label = data.text;
    data.key = data.id;
    data.value = data.id;
    if(data.children){
      dataToTree(data.children);
    }
  });
};
/**
 * 新增单位
 * @class AddCompany
 * @extends {Component}
 */
class AddCompany extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }
  /**
   * 初始化
   */
  componentDidMount() {

  }

  /**
   * 打开新增单位对话框
   */
  onClick = () => {
    this.setState({visible: true});
    this.props.superiorUnitAction();
  }

  handleSave = (obj) => {
    this.props.companyAddAction(obj);
    this.handleCancel();
  }
  /**
   * 关闭新增单位对话框
   */
  handleCancel = () => {
    this.props.form.resetFields();
    this.setState({visible: false});
  }
  /**
   * 保存按钮事件
   */
  handleSubmit = (e) => {
    e.preventDefault();
    this.props.form.validateFields((errors, values) => {
      if(errors) {
        return;
      }
      values = objOfStrPropTrim(values);
      this.handleSave(values);
    });
  }

  render() {
    let {text,form} = this.props;
    let {superiorCompanyList} = this.props;
    return (
      <span>
        <GridButton text={text} color='#FFF' icon='plus' onClick={this.onClick} />
        <SimpleModal title='新增单位' visible={this.state.visible} onOk={this.handleSubmit} onCancel={this.handleCancel}  width={685} >
          <CompanyAddEdit company={{}} submit={this.handleSubmit} superiorUnitData={superiorCompanyList} parentform={form} {...this.props} />
        </SimpleModal>
      </span>
    );
  }
}

AddCompany.propTypes = {
  text: PropTypes.string,
  reload: PropTypes.func,
  superiorCompanyList: PropTypes.any,
  superiorUnitAction: PropTypes.func,
  companyAddAction: PropTypes.func,
  form: PropTypes.any
};

AddCompany.defaultProps = {

};
export default createForm(AddCompany);
