import React, { Component } from 'react';
import PropTypes from 'prop-types';
import funcThrottle from 'amos-processor/lib/utils/funcThrottle';
import {Log, tableFilter} from 'amos-tool';

import SystemTableTree from './../../common/tableComponent/SystemTableTree';
import AddCompany from './AddCompany';
import EditCompany from './EditCompany';
import DelCompany from './DelCompany';
import { companyColumns } from './tableConf';
// import './style/index.scss';
import { calcPermission } from 'amos-processor/lib/config/permission';

/**
 * 单位管理表格
 * @class CompanyMgmt
 * @extends {Component}
 */
class CompanyMgmt extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: [],
      dataList: [], // 原始数据
      tableList: [], // 过滤后的表格数据
      reload: function(){}
    };
  }

  componentDidMount() {
    this.props.companyLevelsAction();
  }

  componentWillReceiveProps(nextProps) {
    Log.debug('CM nextProps', nextProps);
    const dataList = nextProps.tableList;
    this.setState({
      dataList: dataList,
      tableList: dataList
    });
    if(nextProps.needRefreshTable){
      this.state.reload();
    }
  }

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({selectedRows, selectedRowKeys});
  }

  /**
   * 添加表格操作按钮
   */
  addButtons = () => {
    let btns = [];
    let {reload} = this.state;
    // let hasPermission = calcPermission('COMPANY_MGMT');
    btns.push(<AddCompany text='新增' reload={reload} {...this.props} />);
    btns.push(<EditCompany text='编辑' reload={reload}  {...this.props} selectRows={this.state.selectedRows} />);
    btns.push(<DelCompany text='删除' reload={reload} selectRows={this.state.selectedRows} {...this.props} />);
    return btns;
  }

  /**
   * 获取表格刷新方法
   */
  reload = (r) => {
    this.setState({reload: ()=>{r();this.setState({selectedRows: [],selectedRowKeys: []});}},r());
  }

  /**
   * 执行前端数据过滤
   */
  executeFeDataFilter = (value) => {
    const dl = this.state.dataList;
    funcThrottle(this.recombineData, {
      value,
      dl
    }, this, 500, 1000);
  }

  recombineData = ({value, dl}) => {
    Log.debug('CM recombineData', value, dl);
    const newData = tableFilter.recombineData(value, dl);

    this.setState({
      tableList: newData
    });
  }

  render() {
    let {tableList} = this.state;
    let {companyLevels, companyTableAction} = this.props;
    let columns = companyColumns(companyLevels);
    Log.debug('CM recombineData2', this.state.dataList);
    return (
      <div className='table-mgmt-content tree-table iotview-config-table'>
        <SystemTableTree
          columns={columns}
          callBack={this.reload}
          dataList={tableList}
          selectedRowKeys={this.state.selectedRowKeys}
          getTableDataAction={companyTableAction}
          operBtns={this.addButtons()}
          getSelectedRows={this.getSelectedRows}
          invokeFeDataFilter={this.executeFeDataFilter}
        />
      </div>
    );
  }
}

CompanyMgmt.propTypes = {
  companyLevelsAction: PropTypes.func,
  companyTableAction: PropTypes.func,
  tableList: PropTypes.array,
  companyLevels: PropTypes.array
};

CompanyMgmt.defaultProps = {
  companyLevels: []
};

export default CompanyMgmt;
