import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input,Editable } from 'amos-framework';
import OltSerUrl from '../../../consts/urlConsts';
import UpLoadIcon from './upload/UpLoadIcon';
import { deviceCategoryEnum } from  './../../deviceManage/common/DeviceEnum';
import { stringUtil } from './../../deviceManage/common/DeviceLang';

const TextArea = Input.TextArea;
/**
 *
 *
 * @class DeviceBasicInfo
 * @extends {Component}
 */
class DeviceBasicInfo extends Component {
  constructor(props){
    super(props);
    let { updateBasicInfo,equipment,device } = this.props;
    let deviceBasicParam = { name: equipment ? equipment.name : '',descr: equipment ? equipment.descr : '',
      type: equipment ? equipment.type : '',eqpTmplId: device.id };
    updateBasicInfo(deviceBasicParam);
    this.state = {
      deviceBasicParam
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onAttributeChange = (type,e) => {
    let { deviceBasicParam } = this.state;
    let { updateBasicInfo } = this.props;
    deviceBasicParam[type] = e.target.value;
    updateBasicInfo(deviceBasicParam);
    this.setState({ deviceBasicParam });
  }

  render() {
    let { device,setImgFile,equipment,enable } = this.props;
    let { deviceBasicParam } = this.state;
    // let defaultImg = equipment && equipment.logo ? `${OltSerUrl.fetchDeviceImg}/icon/${equipment.logo}` : undefined;
    let imgPath = `${OltSerUrl.fetchDeviceImg}/${device.img}`;
    return (
      <div className='add-device-left-basic'>
        <div className='template-basic-info-title'>设备信息</div>
        <div className='template-basic-icon'>
          <img src={imgPath} alt='' style={{ maxWidth: '159px',maxHeight: '81px',paddingTop: '14px' }} />
          {/*<UpLoadIcon
            enable={enable}
            style={{ top: '-18px','max-width': '100px','max-height': '26px' }}
            setImgFile={setImgFile}
            defaultImg={defaultImg}
          />*/}
        </div>
        <div className='template-basic-name'>
          <div className='ant-form-item-required property-label-name'>设备名称：</div>
          {enable ? <Input value={deviceBasicParam.name}
            onChange={(e) => this.onAttributeChange('name', e)}
            // showOkCancel={false}
            style={{ width: '150px',marginLeft: '10px' }}
            placeholder={'请输入'}
            // innerValueStyle={{ width: '150px','padding-left': '10px' }}
            // useOnBlur={!enable}
            // defaultEditing={enable}
          />
          : <div className='property-normal-label' title={deviceBasicParam.name}>{deviceBasicParam.name}</div>
        }
        </div>
        <div className='template-type-name'>
          <div className='property-label-name'>设备类型：</div>
          <div className='property-normal-label' title={device.name}>{device.name}</div>
        </div>
        <div className='template-basic-model'>
          <div className='property-label-name'>型号：</div>
          <div className='property-normal-label' title={device.model}>{device.model}</div>
        </div>
        <div className='template-basic-catalog'>
          <div className='property-label-name'>设备类别：</div>
          <div className='property-normal-label' title={stringUtil(deviceCategoryEnum, device.type)}>{stringUtil(deviceCategoryEnum, device.type)}</div>
        </div>
        <div className='template-basic-industry'>
          <div className='property-label-name'>所属行业：</div>
          <div className='property-normal-label' title={device.equipTemplateIndustry.name}>{device.equipTemplateIndustry.name}</div>
        </div>
        <div className='template-basic-descr'>
          <div className='property-label-name'>设备描述：</div>
          {enable ? <Input value={deviceBasicParam.descr}
            onChange={(e) => this.onAttributeChange('descr', e)}
            // showOkCancel={false}
            style={{ width: '150px' }}
            placeholder={'请输入'}
            // innerValueStyle={{ width: '150px' }}
            // useOnBlur={!enable}
            // defaultEditing={enable}
          />
          : <div className='property-normal-label' title={deviceBasicParam.descr}>{deviceBasicParam.descr}</div>
          }
        </div>
      </div>
    );
  }
}

DeviceBasicInfo.propTypes = {
  device: PropTypes.object,
  equipment: PropTypes.object,
  updateBasicInfo: PropTypes.func,
  setImgFile: PropTypes.func,
  enable: PropTypes.bool
};

DeviceBasicInfo.defaultProps = {
  enable: true
};

export default DeviceBasicInfo;
