import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input,Popover,Editable } from 'amos-framework';

/**
 *
 *
 * @class DeviceConfigInfo
 * @extends {Component}
 */
class DeviceConfigInfo extends Component {
  constructor(props){
    super(props);
    this.state = {
      deviceConfigParam: {}
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onAttributeChange = (key,e) => {
    let { deviceConfigParam } = this.state;
    let { updateDevicePropertyCell } = this.props;
    deviceConfigParam[key] = e.target.value;
    updateDevicePropertyCell(deviceConfigParam);
    this.setState({ deviceConfigParam });
  }

  getDeviceConfigInfo = () => {
    let { device,updateDevicePropertyCell,equipment,enable } = this.props;
    let { deviceConfigParam } = this.state;
    let content = [];
    device.attributes.map((item)=>{
      let value = deviceConfigParam[`equip_${item.id}`];
      if (value === undefined) {
        if (equipment !== undefined && equipment.id !== undefined) {
          let param = equipment.cfgParamMap;
          value = param[`equip_${item.id}`] ? param[`equip_${item.id}`] : value;
        } else {
          value = item.valueStr;
        }
      }
      deviceConfigParam[`equip_${item.id}`] = value;
      updateDevicePropertyCell(deviceConfigParam);
      content.push(
        <div key={item.id} className='template-config-common'>
          <div className='property-label-name' title={item.displayName} >
            {item.displayName}：
          </div>
          {enable ? <Input value={value}
            onChange={(e) => this.onAttributeChange(`equip_${item.id}`, e)}
            // showOkCancel={false}
            style={{ width: '152px' }}
            placeholder={'请输入'}
            // innerValueStyle={{ width: '152px' }}
            // useOnBlur={!enable}
            // defaultEditing={enable}
          />
          : <div className='property-normal-label' title={value} >{value}</div>
        }
        </div>);
    });
    return content;
  }


  render() {
    return (
      <div className='add-device-left-config'>
        <div className='template-config-info-title'>设备属性</div>
        <div className='template-config-info-content'>
          {this.getDeviceConfigInfo()}
        </div>
      </div>
    );
  }
}

DeviceConfigInfo.propTypes = {
  device: PropTypes.object,
  equipment: PropTypes.object,
  updateDevicePropertyCell: PropTypes.func,
  enable: PropTypes.bool
};

DeviceConfigInfo.defaultProps = {
  enable: true
};

export default DeviceConfigInfo;
