import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { PubSub } from 'ray-eventpool';
import { CONFIG_PANEL_SHOW_TOPIC } from './../../common/ActionConf';

/**
 *
 *
 * @class InterfaceCommonCell
 * @extends {Component}
 */
class InterfaceCommonCell extends Component {
  constructor(props){
    super(props);
    let { content,updateInterfaceCellStatus,equipment } = this.props;
    let enable = true;
    if (equipment !== undefined && equipment.id !== undefined) {
      let param = equipment.cfgParamMap.selIntfcIds;
      if (param !== undefined && param.includes(`${content.id}`)) {
        enable = true;
      } else {
        enable = false;
      }
    }
    updateInterfaceCellStatus(content.id,enable);
    this.state = {
      usedState: enable,
      testSuccess: true
    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getImgByState = () => {
    let content = [];
    let { usedState } = this.state;
    if (usedState) {
      content.push(<img src={require('./../../../../assets/iot/deviceManage/disable.png')} alt='' />);
      content.push(<img src={require('./../../../../assets/iot/deviceManage/empty.png')} alt='' />);
    } else {
      content.push(<img src={require('./../../../../assets/iot/deviceManage/enable.png')} alt='' />);
      content.push(<img src={require('./../../../../assets/iot/deviceManage/empty.png')} alt='' />);
    }
    return content;
  }

  /**
   *
   * interface-cell-enable-root:bule
   * interface-cell-disable-root:grey
   * interface-cell-success-root:green
   * interface-cell-fail-root:red
   * @memberof InterfaceCommonCell
   */
  getStyleByState = () => {
    let { usedState } = this.state;
    if (usedState) {
      return 'interface-cell-enable-root';
    } else {
      return 'interface-cell-disable-root';
    }
  }

  openConfigPanel = () => {
    let { content } = this.props;
    PubSub.publish(CONFIG_PANEL_SHOW_TOPIC.trigger, {
      type: 1,
      id: content.id,
      intfc: content
    });
  }

  changeEnableState = (e) => {
    e.stopPropagation();
    let { usedState } = this.state;
    let { updateInterfaceCellStatus,content,equipment } = this.props;
    updateInterfaceCellStatus(content.id,!usedState);
    this.setState({ usedState: !usedState });
  }

  render() {
    let { content,enable } = this.props;
    let style = this.getStyleByState();
    return (
      <div className={style} title={content.name} >
        <div className='interface-cell-text'>{content.name}</div>
      </div>
    );
  }
}

InterfaceCommonCell.propTypes = {
  content: PropTypes.object,
  updateInterfaceCellStatus: PropTypes.func,
  equipment: PropTypes.object,
  enable: PropTypes.bool
};

export default InterfaceCommonCell;
