import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Input } from 'amos-framework';
import { isNum } from 'ray-validate';

/**
 *
 * 门限输入
 * @class ThresholdInput
 * @extends {Component}
 */
class ThresholdInput extends Component {
  constructor(props){
    super(props);
    this.state = {
      thresholdValue: {
        upper: props.upper,
        lower: props.lower
      }
    };
  }
  componentWillMount() {

  }

  componentDidMount(){
    let { infoKey,updateCapacityThresholdInfo } = this.props;
    let { thresholdValue } = this.state;
    updateCapacityThresholdInfo(infoKey,thresholdValue);
  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  onInputChange = (key,e) => {
    let { infoKey,updateCapacityThresholdInfo } = this.props;
    let { thresholdValue } = this.state;
    let value = e.target.value;
    if (isNum(value) || (isNum(value.substring(0,value.length - 1)) && value.substring(value.length - 1,value.length) === '.')) {
      thresholdValue[key] = value;
      updateCapacityThresholdInfo(infoKey,thresholdValue);
      this.setState({ thresholdValue });
    }
  }

  render() {
    let { thresholdValue } = this.state;
    let { unit,disabled,isHidden } = this.props;
    let inputStyle = 'threshold-input-root';
    if (isHidden) {
      inputStyle = `${inputStyle} hidden-threshold-input`;
    }
    return (
      <div className={inputStyle}>
        <Input
          disabled={disabled}
          value={thresholdValue.lower}
          placeholder=""
          className='threshold-end-input'
          onChange={(e) => this.onInputChange('lower', e)}
          title={thresholdValue.lower}
        />
        <div className='threshold-input-symbol'>-</div>
        <Input
          disabled={disabled}
          value={thresholdValue.upper}
          placeholder=""
          className='threshold-start-input'
          onChange={(e) => this.onInputChange('upper', e)}
          title={thresholdValue.upper}
        />
        <div title={unit} className='threshold-input-unit'>{unit}</div>
      </div>
    );
  }
}

ThresholdInput.propTypes = {
  unit: PropTypes.string,
  upper: PropTypes.number,
  lower: PropTypes.number,
  infoKey: PropTypes.string,
  updateCapacityThresholdInfo: PropTypes.func,
  disabled: PropTypes.bool,
  isHidden: PropTypes.bool
};

ThresholdInput.__AMOS_CHECKBOX = true;

export default ThresholdInput;
