import React, { Component } from 'react';
import PropTypes from 'prop-types';
import CellOperatePanel from './CellOperatePanel';
import { OltSerUrl } from '../../../consts/urlConsts';
import './commonDeviceCell.scss';

/**
 *
 * 公共设备card
 * @class CommonDeviceCell
 * @extends {Component}
 */
class CommonDeviceCell extends Component {
  constructor(props){
    super(props);
    this.state = {

    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getBodyBottomContent = () => {
    let { type,deviceNum,deviceInfo } = this.props;
    let content = [];
    if (type === 1) {
      content.push(<div key={'new'} style={{ paddingTop: '10px' }}>创建一个您的新设备</div>);
      content.push(<div key={'type'}>专家模式/模板创建</div>);
    } else if (type === 2) {
      content.push(<div key={'sum'} className='device-sum'>设备总数：<label style={{ color: '#345FAA' }}>{deviceNum}</label>个</div>);
      content.push(<CellOperatePanel key={deviceInfo.id} device={deviceInfo} {...this.props} />);
    }
    return content;
  }

  clickCard = (e) => {
    e.stopPropagation();
    let { type,clickDeviceTemplate,deviceInfo } = this.props;
    if (type === 1) {
      clickDeviceTemplate(undefined);
    } else if (type === 2) {
      clickDeviceTemplate(deviceInfo);
    }
  }

  getImg = () => {
    let content = [];
    let { imgUrl } = this.props;
    if (imgUrl === undefined) {
      content.push(<img key={'device_default'} src={require('./../../../assets/iot/deviceManage/device_default.png')} alt='' />);
    } else {
      content.push(<img key={imgUrl} src={`${OltSerUrl.fetchDeviceImg}/${imgUrl}`} alt='' />);
    }
    return content;
  }

  render() {
    let { type,deviceInfo,deleteTemplate } = this.props;
    return (
      <div tabIndex={'0'} className='device-card-root' onClick={this.clickCard}>
        <div className='device-card-head'>
          <div className='device-card-head-text'>
            {deviceInfo !== undefined ? deviceInfo.name : ''}
          </div>
          {/*<div className='device-card-head-operate'>
            {type === 1 ? <div /> : <img src={require('./../../../assets/iot/deviceManage/close.png')} onClick={(e)=>deleteTemplate(deviceInfo.id,e)} alt='' />}
    </div>*/}
        </div>
        <div className='device-card-body'>
          <div className='device-card-body-center'>
            {type === 1 ? <img src={require('./../../../assets/iot/deviceManage/add_template.png')} alt='' /> :
            this.getImg()}
          </div>
          <div className='device-card-body-text'>
            {this.getBodyBottomContent()}
          </div>
        </div>
      </div>
    );
  }
}

CommonDeviceCell.propTypes = {
  type: PropTypes.number,
  deviceNum: PropTypes.number,
  imgUrl: PropTypes.string,
  clickDeviceTemplate: PropTypes.func,
  updateMainView: PropTypes.func,
  deviceInfo: PropTypes.object,
  deleteTemplate: PropTypes.func
};

export default CommonDeviceCell;
