import React, { Component } from 'react';
import PropTypes from 'prop-types';
import DefaultCreateDeviceLeft from './DefaultCreateDeviceLeft';
import './createDeviceLeft.scss';
import DeviceInfoLeft from './DeviceInfoLeft';

/**
 *
 *
 * @class CreateDeviceLeft
 * @extends {Component}
 */
class CreateDeviceLeft extends Component {
  constructor(props){
    super(props);
    this.state = {

    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getContent = () => {
    let content = [];
    let { device,statisticsData,totalCount } = this.props;
    if (device !== undefined) {
      content.push(<DeviceInfoLeft key={'left'} device={device} />);
    } else {
      content.push(<DefaultCreateDeviceLeft key={'default'} statisticsData={statisticsData} totalCount={totalCount} />);
    }
    return content;
  }

  render() {
    return (
      <div className='create-device-left-root'>
        {this.getContent()}
      </div>
    );
  }
}

CreateDeviceLeft.propTypes = {
  device: PropTypes.object,
  statisticsData: PropTypes.array,
  totalCount: PropTypes.number
};

export default CreateDeviceLeft;
