import React, { Component } from 'react';
import PropTypes from 'prop-types';
import DefaultLeftTextCell from './DefaultLeftTextCell';
/**
 *
 *
 * @class DefaultCreateDeviceLeft
 * @extends {Component}
 */
class DefaultCreateDeviceLeft extends Component {
  constructor(props){
    super(props);
    this.state = {

    };
  }
  componentWillMount() {

  }

  componentDidMount(){

  }

  componentWillReceiveProps(nextProps) {

  }

  componentWillUnmount() {

  }

  getStatisticsContent = () => {
    let { statisticsData } = this.props;
    let content = [];
    let key = 0;
    statisticsData && statisticsData.map(i=>{
      key = key + 1;
      content.push(<DefaultLeftTextCell key={key} sumResult={i} />);
    });
    return content;
  }

  render() {
    let { statisticsData,totalCount } = this.props;
    return (
      <div className='default-device-left-root'>
        <div className='default-device-left-top'>
          <div className='default-device-top-one'>我的设备</div>
          <div className='default-device-top-two'>设备类型：<label style={{ color: '#345FAA' }}>{statisticsData !== undefined ? statisticsData.length : 0}</label>个</div>
          <div className='default-device-top-three'>设备总数：<label style={{ color: '#345FAA' }}>{totalCount}</label>个</div>
        </div>
        <div className='default-device-left-bottom'>
          {this.getStatisticsContent()}
        </div>
      </div>
    );
  }
}

DefaultCreateDeviceLeft.propTypes = {
  statisticsData: PropTypes.array,
  totalCount: PropTypes.number
};

export default DefaultCreateDeviceLeft;
