import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Progress,Button,Row } from 'amos-antd';
import { OltSerUrl } from '../../../consts/urlConsts';
import { AmosFetch } from '../../../utils/processor';

import Icon from 'amos-icon';

import './onlineTest.scss';


// const connectData = {
//   1: '请求超时！',
//   2: 'ok',
//   3: 'ok',
//   4: 'ok',
//   5: '链接异常！',
//   6: 'ok',
//   7: 'ok'
// };

// const intfcList = [
// 	{ id: 1,name: 'ping',attribute: [{ id: 1,name: 'loRa',maxValue: 6,minValue: 2 },{ id: 2,name: 'GPS',maxValue: 10,minValue: 5 }] },
// 	{ id: 2,name: '有线',attribute: [{ id: 3,name: '胎压',maxValue: 6,minValue: 2 },{ id: 4,name: '液压',maxValue: 3,minValue: 1 }] },
// 	{ id: 3,name: '串口',attribute: [{ id: 5,name: '上装',maxValue: 4,minValue: 1 }] },
// 	{ id: 4,name: '3G/4G',attribute: [{ id: 6,name: '人员',maxValue: 6,minValue: 2 }] },
// 	{ id: 5,name: '485',attribute: [{ id: 7,name: 'OBD',maxValue: 6,minValue: 2 }] },
// 	{ id: 6,name: 'NB107',attribute: [{ id: 8,name: '车速',maxValue: 6,minValue: 2 }] },
// 	{ id: 7,name: '蓝牙',attribute: [{ id: 9,name: '温度',maxValue: 6,minValue: 2 }] }
// ];
/**
 * 在线测试
 *
 * @class AddDeviceCard
 * @extends {Component}
 */
class ConnectTest extends Component {
  constructor(props) {
    super(props);
    let percent =  this.props.percent;
    let connectData = this.props.connectData;
    let exprotButton = this.props.exprotButton;

    this.state = {
      connectData,
      flag: false,
      percent,
      exprotButton
    };
  }

  componentWillReceiveProps(nextProps) {
    this.setState({
      percent: nextProps.percent
    });
    if (nextProps.percent === 100) {
      this.setState({exprotButton:"inline"})
    } else {
      this.setState({exprotButton:"none"})
    }
  }

  getViewForList = () =>{
    let intfcList = this.props.intfcList;
    let { connectData } = this.state;
    let viewList = [];
    intfcList.map((data)=>{
      if (connectData[data.id] && connectData[data.id] === 'ok') {
        viewList.push(<Row>
          <span style={{ fontSize: '14px' }} >{data.name}</span>
          <Icon icon="ok" size='lg' style={{ color: 'red',float: 'right',marginTop: '5px' }} />
          <div className='divider-css' />
        </Row>);
      } else if (connectData[data.id] && connectData[data.id] !== 'ok') {
        let param = `flag${data.id}`;
        viewList.push(<Row onClick={()=>{this.anErrorInfo(param);}} >
          <span style={{ fontSize: '14px',color: 'red' }} >{data.name}</span>
          <Icon icon="close" size='lg' style={{ color: 'red',float: 'right',marginTop: '5px' }} />
          <div className='divider-red' />
          { this.state[param] ?
            <div><span style={{ color: 'red' }} >{connectData[data.id]}</span><div className='divider-css' /></div> :
            null}
        </Row>);
      } else {
        viewList.push(<Row>
          <span style={{ fontSize: '14px' }} >{data.name}</span>
          <div className='divider-css' />
        </Row>);
      }
    });
    return viewList;
  }

  anErrorInfo=(key) =>{
    this.setState({
      [key]: !this.state[key]
    });

  }

  TodoTest=()=>{

    this.setState({
      percent: 0
    });

    let imgInfo = { 'binaryImg': null,'imgName': 'default.png' };
    this.props.saveEquipmnet(imgInfo,'connect');
  }

  ExportData=()=>{
    let url = `${OltSerUrl.exportData}`;
    AmosFetch.get(url).then(res => {
      if (res.ok) {
        return res;
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        console.log(data);
      }
    });
  }

  render() {
    let href = `${OltSerUrl.exportData}`;
    return (
      <div>
        <div className='online-test-top' >
          <Row><Progress type="circle" percent={this.state.percent} width={175} /></Row>
          <Row style={{ marginTop: '20px' }} ><Button type="primary" onClick={this.TodoTest} >测试</Button> <a href={href}><Button type="primary" style={{display:this.state.exprotButton}}>导出测试报告</Button></a></Row>
        </div>
        <div className='online-test-bottom' >
          <div className='bottom-one' >
            <Row><span style={{ fontSize: '20px',fontWeight: 'bold' }} >接口连接</span></Row>
            <div className='divider-css' />
            <Row><span style={{ fontSize: '14px',fontWeight: 'bold' }} >固定接口连接测试</span></Row>
            <div className='divider-css' />
            {
              this.getViewForList()
            }
          </div>
        </div>
      </div>
    );
  }
}

ConnectTest.propTypes = {
  intfcList: PropTypes.any,
  saveEquipmnet: PropTypes.func,
  visible: PropTypes.any,
  percent: PropTypes.any,
  connectData: PropTypes.any
};

export default ConnectTest;
