import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Progress,Button,Row } from 'amos-antd';
import { OltSerUrl } from '../../../consts/urlConsts';

import './onlineTest.scss';

// const intfcList = [
// 	{ id: 1,name: 'ping',attribute: [{ id: 1,name: 'loRa',maxValue: 8,minValue: 2,value: 8 },{ id: 2,name: 'GPS',maxValue: 10,minValue: 4,value: 4 }] },
// 	{ id: 2,name: '有线',attribute: [{ id: 3,name: '胎压',maxValue: 6,minValue: 2,value: 4 },{ id: 4,name: '液位',maxValue: 3,minValue: 1,value: 2 }] },
// 	{ id: 3,name: '串口',attribute: [{ id: 5,name: '上装',maxValue: 4,minValue: 1,value: 2 }] },
// 	{ id: 4,name: '3G/4G',attribute: [{ id: 6,name: '人员',maxValue: 6,minValue: 2 }] },
// 	{ id: 5,name: '485',attribute: [{ id: 7,name: 'OBD',maxValue: 6,minValue: 2,value: 7 }] },
// 	{ id: 6,name: 'NB107',attribute: [{ id: 8,name: '车速',maxValue: 6,minValue: 2,value: 4 }] },
// 	{ id: 7,name: '蓝牙',attribute: [{ id: 9,name: '温度',maxValue: 6,minValue: 2,value: 6 }] }
// ];
/**
 * 在线测试
 *
 * @class AddDeviceCard
 * @extends {Component}
 */
class PerformanceTest extends Component {
  constructor(props) {
    super(props);
    let quotaList = this.props.quotaList;
    let quotaSelecteList = this.props.quotaSelecteList;
    let percent =  this.props.percent;
    let exprotButton = this.props.exprotButton;

    this.state = {
      quotaList,
      quotaSelecteList,
      percent,
      exprotButton
    };
  }

  componentWillReceiveProps(nextProps) {
    this.setState({
      percent: nextProps.percent
    });
    if (nextProps.percent === 100) {
      this.setState({exprotButton:"inline"})
    } else {
      this.setState({exprotButton:"none"})
    }
  }

  getViewForList = () =>{
    let viewList = [];
    let attribute = this.state.quotaSelecteList;
    if (attribute.length > 0) {
      attribute.map((param)=>{
        let value = param.value;
        let datatype = param.datatype;
        let minValue = param.minValue;
        let maxValue = param.maxValue;
        if (!value || value === null){
          viewList.push(<Row>
            <span style={{ fontSize: '14px' }} >{param.displayName}</span>
            <span style={{ color: 'red',float: 'right',marginTop: '5px' }} >--</span>
            <div className='divider-css' />
          </Row>);
        } else {
          if ((datatype === 1 || datatype === 2) && (value < minValue || value > maxValue)){
            viewList.push(<Row>
              <span style={{ fontSize: '14px',color: 'red' }} >{param.displayName}</span>
              <span style={{ color: 'red',float: 'right',marginTop: '5px' }} >{param.value}</span>
              <div className='divider-red' />
            </Row>);
          } else {
            viewList.push(<Row>
              <span style={{ fontSize: '14px' }} >{param.displayName}</span>
              <span style={{ color: 'red',float: 'right',marginTop: '5px' }} >{param.value}</span>
              <div className='divider-css' />
            </Row>);
          }
        }
      });
    }
    return viewList;
  }

  anErrorInfo=(key) =>{
    this.setState({
      [key]: !this.state[key]
    });

  }

  TodoTest=()=>{
    this.setState({
      percent: 0
    });

    let imgInfo = { 'binaryImg': null,'imgName': 'default.png' };
    this.props.saveEquipmnet(imgInfo,'metric');
  }

  export =()=>{
    let url = OltSerUrl.exportData;
    window.location.href = encodeURI(encodeURI(url));
  }

  render() {
    let href = `${OltSerUrl.exportData}`;

    return (
      <div>
        <div className='online-test-top' >
          <Row><Progress type="circle" percent={this.state.percent} width={175} /></Row>
          <Row style={{ marginTop: '20px' }} ><Button type="primary" onClick={this.TodoTest} >测试</Button> <a href={href} ><Button type="primary" style={{display:this.state.exprotButton}}>导出测试报告</Button></a></Row>
        </div>
        <div className='online-test-bottom' >
          <div className='bottom-one' >
            <Row><span style={{ fontSize: '20px',fontWeight: 'bold' }} >数据采集</span></Row>
            <div className='divider-css' />
            <Row><span style={{ fontSize: '14px',fontWeight: 'bold' }} >固定采集指标测试</span></Row>
            <div className='divider-css' />
            {
              this.getViewForList()
            }
          </div>
        </div>
      </div>
    );
  }
}

PerformanceTest.propTypes = {
  quotaList: PropTypes.any,
  quotaSelecteList: PropTypes.any,
  saveEquipmnet: PropTypes.func,
  visible: PropTypes.any,
  percent: PropTypes.any
};

export default PerformanceTest;
