import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Card } from 'amos-antd';
import Icon from 'amos-icon';

/**
 * 表格展示的卡片元素
 *
 * @class AddDeviceCard
 * @extends {Component}
 */
class AddDeviceCard extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }
  onClick = () => {
    this.props.updateAddView('4');
  }

  render() {
    return (
      <div className='table-card'>
        <Card bodyStyle={{ textAlign: 'center' }} title='新建设备接口' >
          <div className='index-add-img' onClick={this.onClick} >
            <Icon className="interface-lib-icon" icon="add" />
          </div>
        </Card>
      </div>
    );
  }
}

AddDeviceCard.propTypes = {
  cardData: PropTypes.any,
  updateAddView: PropTypes.func
};

export default AddDeviceCard;
