import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Icon,Row,Col } from 'amos-antd';
import CommunitySelectedOptionFilter from './../../common/filterOptions/communityOptionsFilter';


/**
 * 筛选按钮
 *
 * @class FilterBtn
 * @extends {Component}
 */
class FilterBtn extends Component {
  constructor(props) {
    super(props);
    this.state = {
      communitySelectedOption: []
    };
  }

  communitySelectFunc = (values) => {
    this.setState({ communitySelectedOption: values });
    this.props.filterOnChange(values);
  }

  //单个删除筛选条件
  delBtn = (value) => {
    let { communitySelectedOption } = this.state;
    let filterList = [];
    communitySelectedOption.map(option=>{
      if (option.label === value) {
        option.selected = false;
        option.style = 'all-filter-btn';
      }
      if (option.selected) {
        filterList.push(option);
      }
    });
    this.props.filterOnChange(filterList);
    this.setState({ communitySelectedOption });
  }

  //加载已选择的条件
  SelectOptions = () => {
    let { communitySelectedOption } = this.state;
    let res = [];
    communitySelectedOption.map(option=>{
      if (option.selected) {
        res.push(
          <div key={`option${option.value}`} id={option.value} onClick={() => this.delBtn(option.label)} className='select-filter-btn'>
            {option.label}<Icon type='close' />
          </div>);
      }
    });
    return res;
  }

  render() {
    return (
      <div>
        <Row>
          <Col span={8}>
            <span>筛选条件：</span>
          </Col>
          <Col span={16}>
            {this.SelectOptions()}
          </Col>
        </Row>
        <Row>
          <Col span={8}>
            <span>通讯方式：</span>
          </Col>
          <Col span={16}>
            <CommunitySelectedOptionFilter communitySelectFunc={this.communitySelectFunc} {...this.props} />
          </Col>
        </Row>
      </div>
    );
  }
}

FilterBtn.propTypes = {
  filterOnChange: PropTypes.func,
  communityOptions: PropTypes.array
};

export default FilterBtn;
