import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Card,Icon,Modal,Message } from 'amos-antd';
import { completeDevIcon } from '../../../consts/viewConsts';

/**
 * 表格展示的卡片元素
 *
 * @class TableCard
 * @extends {Component}
 */
class TableCard extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  confirm = () => {
    let { cardData } = this.props;
    this.props.delInfo(cardData.id);
  }

  delBtn = () => {
    Modal.confirm({
      title: '删除',
      content: '是否删除所选信息？',
      okText: '确定',
      cancelText: '取消',
      onOk: this.confirm,
      onCancel() {}
    });
  };

  //显示详情页面
  showDetail = () => {
    let { updateAddView,cardData } = this.props;
    updateAddView('3',cardData);
  }

  //标题额外按钮
  extraBtn = () => {
    const { isDel, cardData = {} } = this.props;
    const iconName = cardData.typeImg || 'interface.png';
    const extraIcon = completeDevIcon(iconName);
    let res = [];
    res.push(<div key={`left1`} className='title-left'><img src={extraIcon} alt="" /></div>);
    if (isDel) {
      res.push(<a key={`del1`} onClick={this.delBtn} ><Icon type='close'  className='basic-info-add' /></a>);
    } else {
      res.push(<div key={`block1`} style={{ width: '12px',display: 'inline-block' }} />);
    }
    return res;
  }



  render() {
    let { cardData } = this.props;
    let protocolName = cardData ? cardData.name : '';
    let comMethod = cardData ? cardData.communityProtocol.name : '';
    let info = cardData ? cardData.remark : '';
    return (
      <div className='table-card'>
        <Card title={protocolName} extra={this.extraBtn()} >
          <div onClick={this.showDetail} >
            <p title={comMethod}>通讯方式：{comMethod}</p>
            <p title={info} style={{ 'overflow': 'hidden','text-overflow': 'ellipsis','white-space': 'nowrap' }}>说&emsp;&emsp;明：{info}</p>
          </div>
        </Card>
      </div>
    );
  }
}

TableCard.propTypes = {
  cardData: PropTypes.any,
  isDel: PropTypes.bool,
  updateAddView: PropTypes.func,
  delInfo: PropTypes.func
};

export default TableCard;
