import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Icon,Form } from 'amos-antd';
import AddEditInterfaceProperty from './AddEditInterfaceProperty';
import './interface-detail.scss';

const createForm = Form.create();
/**
 * 新增属性
 */
class AddInterfaceProperty extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,repuestType,requestIntfcAttrs,intfcId } = this.props;
    return (
      <div className='interface-detail-property-button' onClick={this.onClick} >
        {repuestType && repuestType === 'addProperty' ? <img src={require('./../../../assets/iot/deviceManage/add.png')} alt='' />
       : <div className='detail-add-img'><img src={require('./../../../assets/iot/img/list_add.png')} alt='' />
          <label>新增</label>
        </div>      
       }
        <Modal maskClosable={false} title='新增属性' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditInterfaceProperty intfcId={intfcId} requestIntfcAttrs={requestIntfcAttrs} addIntfcArrt={this.props.addIntfcArrt} form={form} callBack={this.handCancel} />
        </Modal>
      </div>
    );
  }
}

AddInterfaceProperty.propTypes = {
  form: PropTypes.any,
  repuestType: PropTypes.string
};

export default createForm(AddInterfaceProperty);
