import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row,Col,Popover } from 'amos-antd';
import EditInterfaceProperty from './EditInterfaceProperty';
import './interface-detail.scss';


/**
 * 接口属性单元
 *
 * @class InterfacePropertyCell
 * @extends {Component}
 */
class InterfacePropertyCell extends Component {
  constructor(props) {
    super(props);
    this.state = {
      textEdit: false
    };
  }

  componentDidMount(){

  }

  /**
   * 处理编辑事件
   *
   * @memberof InterfacePropertyCell
   */
  handleEditProperty = (e) => {
    console.log();
  }

  /**
   * 处理新增事件
   *
   * @memberof InterfacePropertyCell
   */
  handleAddProperty = (e) => {
    console.log();
  }

  deleteInfo =() => {
    let propertyInfo = this.props.propertyInfo;
    this.props.deleteInterfaceProperty(propertyInfo.id);
  }

  /**
   * type: 1表示变量，2表示常量，3表示标签，4输出
   * dataType:1表示整型，2表示浮点型，3表示布尔型，4表示枚举，5表示字符串，6表示密码
   */
  getDataContent = (propertyInfo) => {
    let { type,dataType } = propertyInfo;
    let htmlContent = [];
    if ((type === 1 || type === 4) && (dataType === 1 || dataType === 2))
    {
      htmlContent.push(<div>
        <label>最大值：{propertyInfo.maxValue}</label>
        <div>最小值：{propertyInfo.minValue}</div>
      </div>);
    } else if (dataType === 4 && type !== 3)
    {
      htmlContent.push(<div>
        <Popover placement="top" title={'枚举范围：'} content={propertyInfo.enumRange} >
        <label>枚举范围：{propertyInfo.enumRange}</label>
        </Popover>
      </div>);
    }
    return htmlContent;
  }

  render() {
    let { propertyInfo,requestIntfcAttrs,visibility } = this.props;
    let type = propertyInfo.type;
    if (type){
      switch (propertyInfo.type) {
        case 1:
          type = '变量';
          break;
        case 2:
          type = '常量';
          break;
        case 3:
          type = '标签';
          break;
        default:
          break;
      }
    }

    let dataType = propertyInfo.dataType;
    let valueStr = propertyInfo.valueStr;
    if (valueStr === 'undefined'){
      valueStr = '';
    }
    if (dataType === 3 ){
      if ( valueStr === '0'){
        valueStr = 'true';
      } else {
        valueStr = 'false';
      }
    }
    if (dataType){
      switch (dataType) {
        case 1:
          dataType = '整型';
          break;
        case 2:
          dataType = '浮点型';
          break;
        case 3:
          dataType = '布尔型';
          break;
        case 4:
          dataType = '枚举';
          break;
        case 5:
          dataType = '字符串';
          break;
        case 6:
          dataType = '密码';
          break;
        default:
          break;
      }
    }

    return (
      <div className='interface-cell-detail'>
        <Row>
          <Col span={24}>
            <div className='interface-cell-title'>
              <label style={{ color: 'black', fontSize: 'large', marginLeft: '1.5rem' }}>{propertyInfo.displayName}</label>
              {
                visibility !== 0 ?
                  <div onClick={this.deleteInfo} className='interface-cell-delete-button'>
                    <img src={require('./../../../assets/iot/img/mk_delect.png')} alt='' />
                  </div> :
                null
              }
              {
                visibility !== 0 ?
                  <EditInterfaceProperty propertyInfo={propertyInfo} requestIntfcAttrs={requestIntfcAttrs} /> :
                null
              }

            </div>
            <div className='interface-cell-content'>
              <div>
                <Popover placement="top" title={'属性名：'} content={propertyInfo.name} >
                  <label>属性名：{propertyInfo.name}</label>
                </Popover>
                <Popover placement="top" title={'显示名称：'} content={propertyInfo.displayName} >
                  <div>显示名称：{propertyInfo.displayName}</div>
                </Popover>
              </div>
              <div>
                <div className='single-info'>分类：{type}</div>
              </div>
              <div>
                <div className='single-info'>数据类型：{dataType}</div>
              </div>
              {
                dataType === '浮点型' ?
                  <div>
                    <div className='single-info'>精度：{propertyInfo.precision}</div>
                  </div> :
                null
              }
              {this.getDataContent(propertyInfo)}
              <div>
                <div className='single-info'>默认值：{valueStr}</div>
              </div>
              <div>
                <div className='single-info'>单位：{propertyInfo.unit}</div>
              </div>
              <div>
                <Popover placement="top" title={'描述：'} content={propertyInfo.descr} >
                  <div className='single-info'>描述：{propertyInfo.descr}</div>
                </Popover>
              </div>
            </div>
          </Col>
        </Row>
      </div>
    );
  }
}

InterfacePropertyCell.propTypes = {
  deleteInterfaceProperty: PropTypes.func,
  propertyInfo: PropTypes.any
};

export default InterfacePropertyCell;
