import React, { Component } from 'react';
import { Icon } from 'amos-antd';
import PropTypes from 'prop-types';
import './common.scss';

/**
 * 新增按钮
 *
 * @class AddBtn
 * @extends {Component}
 */
class AddBtn extends Component {
  constructor(props) {
    super(props);

  }


  render() {
    const { text,onClick,icon,disable } = this.props;
    let className = disable ? 'device-add-button-disable' : 'device-add-button';
    return (
      <div className={className} onClick={onClick}>
        <a title={text} >
          <Icon type={icon} />
          <span>{text}</span>
        </a>
      </div>
    );
  }
}

AddBtn.propTypes = {
  text: PropTypes.string,
  onClick: PropTypes.func,
  icon: PropTypes.string,
  disable: PropTypes.bool
};

AddBtn.defaultProps = {
  disable: false
};

export default AddBtn;
