import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Row,Col } from 'amos-antd';
import './common.scss';

/**
 * 通用单元
 *
 * @class CommonCell
 * @extends {Component}
 */
class CommonCell extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  componentDidMount(){

  }

  /**
   * 处理编辑事件
   *
   * @memberof CommonCell
   */
  handleEditProperty = (e) => {
    console.log();
  }

  /**
   * 处理新增事件
   *
   * @memberof CommonCell
   */
  handleAddProperty = (e) => {
    console.log();
  }

  //删除一条数据
  delCard = () => {
    let delfunc = this.deleteCard;
    Modal.confirm({
      title: '删除',
      content: '是否删除所选信息？',
      okText: '确定',
      cancelText: '取消',
      onOk() { delfunc(); },
      onCancel() { }
    });
  };

  deleteCard = () => {
    let id = this.props.cardKey;
    this.props.deleteCellProperty(id);
  }

  render() {
    let { value,contentHtml,calssStyle } = this.props;
    return (
      <div key={value.name} className={calssStyle} >
        <div className='device-detail-title'>
          <Row>
            <Col span={16} offset={2}>
              <div className='device-detail-title-name'>{value.name}</div>
            </Col>
            <Col span={4} offset={2}>
              <Button icon='close' onClick={this.delCard} className='device-detail-title-button' />
            </Col>
          </Row>
        </div>
        <div className='device-detail-title-content'>
          {contentHtml}
        </div>
      </div>
    );
  }
}

CommonCell.propTypes = {
  value: PropTypes.object,
  deleteCellProperty: PropTypes.func,
  cardKey: PropTypes.number,
  key: PropTypes.number,
  contentHtml: PropTypes.array,
  calssStyle: PropTypes.string
};

CommonCell.defaultProps = {
  calssStyle: 'device-common-cell'
};

export default CommonCell;
