const bizs = {
  controlDevice: '控制设备',
  transDevice: '传输设备',
  sensorDevice: '传感设备',
  otherDevice: '其他',
  float: '浮点型',
  int: '整型',
  boolean: '布尔型',
  enum: '枚举',
  string: '字符串',
  password: '密码',
  variable: '变量',
  constant: '常量',
  label: '标签',
  output: '输出',
  capacityCollect: '采集',
  capacityControl: '控制',
  capacityDiagnosis: '诊断',
  up: '上行',
  down: '下行'
};
/**
 * 将string/number 转化为相应的locale数据
 *
 * @export
 * @param {any} enums 具体的枚举实例 来自于 new AmosEnum()
 * @param {any} valueOrKey 枚举的value或者key 默认是从后端获取到的数据
 * @param {any} module 具体需要进行国际化的模块, exp： bizs
 * @returns
 */
export function stringUtil(enums, valueOrKey, module = bizs){
  const tarEnum = enums.get(valueOrKey);

  return tarEnum && tarEnum.key ? module[tarEnum.key] : '';
}

/**
 * 将枚举转换成对象数组
 *
 * @export
 * @param {any} enums 具体的枚举实例 来自于 new AmosEnum()
 * @param {any} module 具体需要进行国际化的模块, default bizs
 * @returns [{key:'SUBMIT',value:1,label:'提交'},{key:'FICTION',value:0,label:'拟制'}]
 */
export function enums2array(enumsModule,module = bizs){
  let result = [];
  enumsModule.enums.forEach(function(item){
    result.push({ key: item.value, value: item.key, label: module[item.key] });
  });
  return result;
}

export {
  bizs
};
