import React, { Component } from 'react';
import PropTypes from 'prop-types';
import TableCard from './TableCard';
import AddDeviceCard from './addDeviceCard';

class TableContainer extends Component {
  constructor(props) {
    super(props);
    this.state = {
      // dataList: []
    };
  }

  // componentWillMount() {
  //   let { visibility,criterias } = this.props;
  //   this.requestMethod(visibility,criterias);
  // }

  componentDidMount(){
    let { visibility,criterias } = this.props;
    this.requestMethod(visibility,criterias);
  }

  componentWillReceiveProps(nextProps) {
    let { visibility,criterias } = nextProps;
    if (this.props.visibility !== visibility) {
      this.requestMethod(visibility,criterias);
    }
  }

  requestMethod = (visibility,finalCriterias) => {
    //此接口传递参数为对象
    // let pageSize = -1;//不分页
    // let defaultCriterias = { visibility,pageSize };
    // Object.assign(defaultCriterias,finalCriterias);
    // AmosFetch.post(OltSerUrl.pageDevice,{ data: defaultCriterias }).then(res => {
    //   if (res.ok) {
    //     return res.json();
    //   }
    //   else
    //   {
    //     throw new Error('从服务端获取数据失败！');
    //   }
    // }).then((data)=>{
    //   if (data.result === 'SUCCESS'){
    //     if (data.content !== null){
    //       this.setState({ dataList: data.content });
    //     }
    //   } else {
    //     this.setState({ dataList: [] });
    //   }
    // });
  }

  //动态组表格
  showTable = () => {
    // let { dataList } = this.props;
    let res = [];
    let { visibility,isDel,dataList } = this.props;
    //如果是私有协议，则添加新建按钮
    if (visibility === '1'){
      res.push(<AddDeviceCard key={0} {...this.props} />);
    }
    dataList && dataList.map(data => {
      res.push(
        <TableCard
          key={data.id}
          {...this.props}
          cardData={data}
          isDel={isDel}
          requestMethod={this.requestMethod}
        />
      );
    });
    return res;
  }

  render() {
    return (
      <div className='table-container'>
        {this.showTable()}
      </div>
    );
  }
}

TableContainer.propTypes = {
  isDel: PropTypes.bool,
  criterias: PropTypes.object,
  visibility: PropTypes.string,
  dataList: PropTypes.object
};

export default TableContainer;
