import React, { Component } from 'react';
import { Tabs } from 'amos-antd';
import { AmosFetch } from '../../utils/processor';
import OltSerUrl from '../../consts/urlConsts';
import PublicDevice from './publicDevice';
import PrivateDevice from './privateDevice';
import AddDevice from './privateDevice/addDevice';
import PrivateDeviceDetail from './privateDevice/PrivateDeviceDetail';
import SearchBar from './common/searchBar';
import './../common/style/commonTabs.scss';
import './../common/style/commonStyle.scss';

const TabPane = Tabs.TabPane;

/**
 *
 * 设备管理
 *
 * @class DeviceManage
 * @extends {Component}
 */
class DeviceManage extends Component {
  constructor(props) {
    super(props);
    let activeKey = '1';
    const newLocal = this.props.location;
    if (newLocal.query.activeKey){
      activeKey = newLocal.query.activeKey;
    }
    this.activeKey = activeKey;
    this.state = {
      criterias: {},
      flag: activeKey,
      communityOptions: [],
      equiptemplateIndustryOptions: [],
      tabContent: [],
      tabPrivateContent: []
    };
  }

  componentWillMount(){


    //获取接口设备接口
    AmosFetch.get(OltSerUrl.communityProtocol).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let communityDataList = [];
        data ? data.dataList.map(e=>{
          communityDataList.push({ value: e.id,label: e.name,selected: false,style: 'all-filter-btn' });
        }) : [];
        this.setState({ communityOptions: communityDataList });
      }
    });

     //获取行业
    AmosFetch.get(OltSerUrl.equiptemplateIndustry).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let equiptemplateIndustryDataList = [];
        data ? data.dataList.map(e=>{
          equiptemplateIndustryDataList.push({ value: e.id,label: e.name,selected: false,style: 'all-filter-btn' });
        }) : [];
        this.setState({ equiptemplateIndustryOptions: equiptemplateIndustryDataList });
      }
    });
    this.requestMethod('0',[]);
  }

  onTabClick = (value) =>{
    if (value === '1') {
      this.requestMethod('0',[],value);
    } else {
      this.requestMethod('1',[],value);
    }
  }

  requestMethod = (visibility,finalCriterias,value) => {
    //此接口传递参数为对象
    let pageSize = -1;//不分页
    let defaultCriterias = { visibility,pageSize };
    Object.assign(defaultCriterias,finalCriterias);
    AmosFetch.post(OltSerUrl.pageDevice,{ data: defaultCriterias }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.content !== null){
          let tabContent = [];
          let tabPrivateContent = [];
          if (value) {
            this.activeKey = value;
            this.setState({
              flag: value
            });
          }
          let activeKey = this.activeKey;
          if (activeKey === '1'){
            tabContent.push(<PublicDevice key={1} dataList={data.content} updateAddView={this.updateAddView} visibility='0' />);
            this.setState({ tabContent });
          } else if (activeKey === '2') {
            tabPrivateContent.push(<PrivateDevice key={2} dataList={data.content} updateAddView={this.updateAddView} visibility='1' />);
            this.setState({ tabPrivateContent });
          }
        }
      }
    });
  }

  updateAddView=(flag,carInfo)=>{
    if (flag === '1') {
      this.requestMethod('0',[]);
    } else if (flag === '2') {
      this.requestMethod('1',[]);
    } else {
      let activeKey = this.activeKey;
      if (activeKey === '1'){
        this.setState({ flag,carInfo,tabContent: this.showTabPane(flag,carInfo) });
      } else if (activeKey === '2') {
        this.setState({ flag,carInfo,tabPrivateContent: this.showTabPane(flag,carInfo) });
      }
    }
  }

  showTabPane = (newflag,newCarInfo,newCriterias) => {
    let { flag,criterias,equiptemplateIndustryOptions } = this.state;
    flag = newflag === undefined ? flag : newflag;
    let carInfo = newCarInfo === undefined ? this.state.carInfo : newCarInfo;
    criterias = newCriterias === undefined ? criterias : newCriterias;
    let res = [];
    switch (flag) {
      case '1'://公共设备
        res.push(<PublicDevice key={1} updateAddView={this.updateAddView} criterias={criterias} visibility='0' />);
        break;
      case '2'://我的设备
        res.push(<PrivateDevice key={2} updateAddView={this.updateAddView} criterias={criterias} visibility='1' />);
        break;
      case '3'://我的设备 详情
        res.push(<PrivateDeviceDetail key={3} carInfo={carInfo} equiptemplateIndustryOptions={equiptemplateIndustryOptions}/>);
        break;
      case '4'://增加设备
        res.push(<AddDevice key={4} updateAddView={this.updateAddView}  equiptemplateIndustryOptions={equiptemplateIndustryOptions}/>);
        break;
      default:
        res.push(<PublicDevice key={1} updateAddView={this.updateAddView} criterias={criterias} visibility='0' />);
        break;
    }
    return res;
  }

  handleCriterias = (criterias) => {
    let activeKey = this.activeKey;
    if (activeKey === '1'){
      this.requestMethod('0',criterias);
    } else if (activeKey === '2') {
      this.requestMethod('1',criterias);
    }
  }


  render() {
    let { flag,communityOptions,tabContent,tabPrivateContent,equiptemplateIndustryOptions } = this.state;
    let activeKey = this.activeKey;
    return (
      <div  className='tabs-outside'>
        <Tabs
          activeKey={activeKey}
          onTabClick={this.onTabClick}
          tabBarExtraContent={<SearchBar flag={flag}
            handleCriterias={this.handleCriterias}
            communityOptions={communityOptions}
            equiptemplateIndustryOptions={equiptemplateIndustryOptions}
          />
          }
        >
          <TabPane tab={<div>公共</div>} key="1">
            {tabContent}
          </TabPane>
          <TabPane tab={<div>我的</div>} key="2">
            {tabPrivateContent}
          </TabPane>
        </Tabs>
      </div>
    );
  }
}

DeviceManage.propTypes = {

};

export default DeviceManage;
