import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Form,Icon } from 'amos-antd';
import AddEditCapacityProperty from './AddEditCapacityProperty';
import './../device-detail.scss';
import './../add-device.scss';

const createForm = Form.create();
/**
 * 新增采集指标
 */
class AddCapacityProperty extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,repuestType,autoCardCalculate,addCapacityProperty,deviceId,getDeviceInfoById,capacityId } = this.props;
    return (
      <div className='interface-detail-property-button' >
        {repuestType && repuestType === 'addProperty' ? <div className='device-add-capacity-property' onClick={this.onClick}>
          <img src={require('./../../../../assets/iot/deviceManage/pop_add.png')} alt='' />
          <label>新增属性</label>
        </div>
          : <div className='detail-add-img' onClick={this.onClick} >
            <img src={require('./../../../../assets/iot/img/list_add.png')} alt='' />
            <label>新增</label>
          </div>}
        <Modal maskClosable={false} title='增加采集指标' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditCapacityProperty
            capacityId={capacityId}
            getDeviceInfoById={getDeviceInfoById}
            deviceId={deviceId}
            form={form}
            addCapacityProperty={addCapacityProperty}
            callBack={this.handCancel}
            autoCardCalculate={autoCardCalculate}
            {...this.props}
          />
        </Modal>
      </div>
    );
  }
}

AddCapacityProperty.propTypes = {
  form: PropTypes.any,
  repuestType: PropTypes.string,
  autoCardCalculate: PropTypes.func,
  addCapacityProperty: PropTypes.func,
  deviceId: PropTypes.number,
  capacityId: PropTypes.number,
  getDeviceInfoById: PropTypes.func
};

export default createForm(AddCapacityProperty);
