import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row } from 'amos-antd';
import AddCapacityProperty from './AddCapacityProperty';
import { classifyEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import CommonCell from './../../common/CommonCell';
import './../../common/common.scss';
import './../device-detail.scss';
import './../add-device.scss';

/**
 * 新增采集指标card
 */
class AddCapacityPropertyCard extends Component {
  constructor(props) {
    super(props);
    this.state = {
      interfaceProList: []
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

  /**
   * 新增后触发面板更新
   *
   * @memberof AddCapacityPropertyCard
   */
  autoCardCalculate= (newInterface) => {
    let interfaceProList = this.state.interfaceProList;
    if (newInterface !== undefined) {
      interfaceProList = [ ...interfaceProList, ...newInterface ];
      this.setState({ interfaceProList });
    }
    this.autoProView();
  }

  /**
   *
   * 面板更新实现
   * @memberof AddCapacityPropertyCard
   */
  autoProView = (newInterface) => {
    let { repuestType,addCapacityProperty } = this.props;
    let interfaceProList = newInterface === undefined ? this.state.interfaceProList : newInterface;
    let antoView = [];
    antoView.push(<div key={0}>
      <AddCapacityProperty repuestType={repuestType} addCapacityProperty={addCapacityProperty} autoCardCalculate={this.autoCardCalculate} />
    </div>);
    if ( interfaceProList.length > 0 ){
      for (let interfacePro of interfaceProList) {
        let contentHtml = [];
        contentHtml.push(<p>分类：{stringUtil(classifyEnum,parseInt(interfacePro.type))}</p>);
        antoView.push(
          <CommonCell
            calssStyle='small-device-common-cell'
            contentHtml={contentHtml}
            cardKey={interfacePro.key}
            value={interfacePro}
            deleteCellProperty={this.deleteCellProperty}
          />);
      }
    }
    return antoView;
  }

  /**
   * 删除Card
   *
   * @memberof AddDevice
   */
  deleteCellProperty = (id) =>{
    //更新card用的数据
    let interfaceList = this.state.interfaceProList;
    let removedList = [];
    for (let value of interfaceList) {
      if (value.key !== id) {
        removedList.push(value);
      }
    }
    this.setState({ interfaceProList: removedList });
    //更新保存用的数据
    this.props.deleteCellCapacityProperty(id);
    //更新页面
    this.autoProView();
  }

  render() {
    return (
      <Row>
        <div className='device-add-capacity-card'>
          {this.autoProView()}
        </div>
      </Row>
    );
  }
}

AddCapacityPropertyCard.propTypes = {
  form: PropTypes.any,
  repuestType: PropTypes.string,
  addCapacityProperty: PropTypes.func,
  deleteCellCapacityProperty: PropTypes.func
};

export default AddCapacityPropertyCard;

