import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Form } from 'amos-antd';
import { Select } from 'amos-framework';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import AddEditDeviceCapacity from './AddEditDeviceCapacity';
import { interfaceDirectionEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import './../device-detail.scss';

const createForm = Form.create();
const Option = Select.Option;
/**
 * 新增能力
 */
class AddDeviceCapacity extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      protocolOption: [],
      interfaceOption: [],
      interfaceMap: {}
    };
  }

  componentWillMount(){

  }

  componentDidMount(){
    this.getAllAvailableProtocols();
    this.getAllAvailableInterfaces(this.props);
  }

  componentWillReceiveProps(nextProps){
    if ( nextProps.deviceInterfaces !== undefined) {
      this.getAllAvailableInterfaces(nextProps);
    }
  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   *
   *
   * @memberof AddDeviceCapacity
   */
  getAllAvailableProtocols = (e) => {
    let finalCriterias = [];
    let defaultCriterias = {};
    finalCriterias.push(defaultCriterias);
    AmosFetch.post(OltSerUrl.protocolDataList,{ data: finalCriterias }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.dataList !== null){
          let protocolList = data.dataList;
          let protocolOption = protocolList.map((item)=>
            <Option key={item.id} value={`${item.id}`}>{item.name}</Option>);
          this.setState({ protocolOption });
        }
      }
    });
  }

  getAllAvailableInterfaces = (nextProps) => {
    let { deviceInterfaces } = nextProps;
    let interfaceOption = [];
    let interfaceMap = {};
    for (let item of deviceInterfaces) {
      interfaceOption.push(<Option key={item.intfcId} value={`${item.intfcId}-${item.intfcDirection}`}>{`${item.intfcDisplayName}-${stringUtil(interfaceDirectionEnum,parseInt(item.intfcDirection))}`}</Option>);
      interfaceMap[parseInt(item.intfcId)] = item.intfcDisplayName;
    }
    this.setState({ interfaceOption,interfaceMap });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,repuestType,visibility } = this.props;
    let { protocolOption,interfaceOption,interfaceMap } = this.state;
    return (
      <div className='capacity-detail-property-button'>
        {visibility === 1 || visibility === undefined ? <div>
          <div className='add-img' onClick={this.onClick}>
            {repuestType && repuestType === 'addProperty' ? <img src={require('./../../../../assets/iot/deviceManage/add.png')} alt='' />
              : <div className='detail-add-img'>
                <img src={require('./../../../../assets/iot/img/list_add.png')} alt='' />
                <label>新增</label>
              </div> }
          </div>
          <Modal maskClosable={false} title='增加数据采集' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
            <AddEditDeviceCapacity
              form={form}
              callBack={this.handCancel}
              autoCardCalculate={this.autoCardCalculate}
              protocolOption={protocolOption}
              interfaceOption={interfaceOption}
              interfaceMap={interfaceMap}
              {...this.props}
            />
          </Modal>
        </div>:null}
      </div>
    );
  }
}

AddDeviceCapacity.propTypes = {
  form: PropTypes.any,
  repuestType: PropTypes.string,
  autoCardCalculate: PropTypes.func,
  deviceInterfaces: PropTypes.array,
  deviceId: PropTypes.number,
  getDeviceInfoById: PropTypes.func,
  visibility: PropTypes.bool
};

export default createForm(AddDeviceCapacity);
