import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row,Card } from 'amos-antd';
import { capacityClassifyEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import AddDeviceCapacity from './AddDeviceCapacity';
import CommonCell from './../../common/CommonCell';
import './../device-detail.scss';
import './../../common/common.scss';

/**
 * 新增数据采集card
 */
class AddDeviceCapacityCard extends Component {
  constructor(props) {
    super(props);
    this.state = {
      interfaceProList: []
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

  /**
   *
   * 新增后触发面板更新
   * @memberof AddDeviceCapacityCard
   */
  autoCardCalculate= (newInterface) => {
    let interfaceProList = this.state.interfaceProList;
    if (newInterface !== undefined) {
      interfaceProList = [ ...interfaceProList, ...newInterface ];
      this.setState({ interfaceProList });
    }
    this.autoProView();
  }

  /**
   *
   * 面板更新实现
   * @memberof AddDeviceCapacityCard
   */
  autoProView = (newInterface) => {
    let { repuestType,addDeviceCapacity,deviceInterfaces } = this.props;
    let interfaceProList = newInterface === undefined ? this.state.interfaceProList : newInterface;
    let antoView = [];
    antoView.push(<div key={0}>
      <AddDeviceCapacity deviceInterfaces={deviceInterfaces} repuestType={repuestType} addDeviceCapacity={addDeviceCapacity} autoCardCalculate={this.autoCardCalculate} />
    </div>);
    if ( interfaceProList.length > 0 ){
      for (let interfacePro of interfaceProList) {
        let contentHtml = [];
        contentHtml.push(<p>分&emsp;&emsp;类：{stringUtil(capacityClassifyEnum,parseInt(interfacePro.type))}</p>);
        contentHtml.push(<p>接&emsp;&emsp;口：{interfacePro.intfcDisplayName}</p>);
        antoView.push(
          <CommonCell contentHtml={contentHtml} cardKey={interfacePro.key} value={interfacePro} deleteCellProperty={this.deleteCellProperty} />);
      }
    }
    return antoView;
  }

  /**
   * 删除Card
   *
   * @memberof AddDevice
   */
  deleteCellProperty = (id) =>{
    //更新card用的数据
    let interfaceList = this.state.interfaceProList;
    let removedList = [];
    for (let value of interfaceList) {
      if (value.key !== id) {
        removedList.push(value);
      }
    }
    this.setState({ interfaceProList: removedList });
    //更新保存用的数据
    this.props.deleteCellCapacity(id);
    //更新页面
    this.autoProView();
  }

  render() {
    return (
      <Row>
        {this.autoProView()}
      </Row>
    );
  }
}

AddDeviceCapacityCard.propTypes = {
  repuestType: PropTypes.string,
  addDeviceCapacity: PropTypes.func,
  deleteCellCapacity: PropTypes.func,
  deviceInterfaces: PropTypes.array
};

export default AddDeviceCapacityCard;
