import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Form,Button } from 'amos-antd';
import { Select } from 'amos-framework';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import AddEditDeviceInterface from './AddEditDeviceInterface';
import './../device-detail.scss';

const createForm = Form.create();
const Option = Select.Option;
/**
 * 新增接口
 */
class AddDeviceInterface extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      interfaceOption: [],
      interfaceMap: {}
    };
  }

  componentWillMount(){

  }

  componentDidMount(){
    this.getAllAvailableInterfaces();
  }

  componentWillReceiveProps(){

  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   *
   *
   * @memberof AddDeviceInterface
   */
  getAllAvailableInterfaces = () => {
    let finalCriterias = [];
    let defaultCriterias = { };
    finalCriterias.push(defaultCriterias);
    AmosFetch.post(OltSerUrl.interfaceDataList,{ data: finalCriterias }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.dataList !== null){
          let interfaceList = data.dataList;
          let interfaceOption = [];
          let interfaceMap = {};
          for (let item of interfaceList) {
            interfaceOption.push(<Option key={item.id} value={`${item.id}`}>{item.name}</Option>);
            interfaceMap[item.id] = item.name;
          }
          this.setState({ interfaceOption,interfaceMap });
        }
      }
    });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,autoCardCalculate,addDeviceInterface,deviceId,getDeviceInfoById,repuestType } = this.props;
    let { interfaceOption,interfaceMap } = this.state;
    return (
      <div className='interface-detail-property-button'>
        <div className='add-img' onClick={this.onClick}>
          {repuestType && repuestType === 'addProperty' ? <img src={require('./../../../../assets/iot/deviceManage/add.png')} alt='' />
            : <div className='detail-add-img'>
              <img src={require('./../../../../assets/iot/img/list_add.png')} alt='' />
              <label>新增</label>
            </div> }
        </div>
        <Modal maskClosable={false} title='增加设备接口' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditDeviceInterface
            form={form}
            callBack={this.handCancel}
            addDeviceInterface={addDeviceInterface}
            autoCardCalculate={autoCardCalculate}
            interfaceOption={interfaceOption}
            interfaceMap={interfaceMap}
            deviceId={deviceId}
            getDeviceInfoById={getDeviceInfoById}
            {...this.props}
          />
        </Modal>
      </div>
    );
  }
}

AddDeviceInterface.propTypes = {
  form: PropTypes.any,
  repuestType: PropTypes.string,
  deleteCellInterface: PropTypes.func,
  autoCardCalculate: PropTypes.func,
  addDeviceInterface: PropTypes.func,
  deviceId: PropTypes.number,
  getDeviceInfoById: PropTypes.func
};

export default createForm(AddDeviceInterface);
