import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Icon,Form } from 'amos-antd';
import AddEditDeviceProperty from './AddEditDeviceProperty';
import './../device-detail.scss';

const createForm = Form.create();
/**
 * 新增设备属性
 */
class AddDeviceProperty extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,deviceId,getDeviceInfoById,repuestType } = this.props;
    return (
      
      <div className='device-detail-property-button'>
        <div className='add-img' onClick={this.onClick}>
        {repuestType && repuestType === 'addProperty' ? <img src={require('./../../../../assets/iot/deviceManage/add.png')} alt='' />
          : <div className='detail-add-img'>
            <img src={require('./../../../../assets/iot/img/list_add.png')} alt='' />
            <label>新增</label>
          </div> }
      </div>
        <Modal maskClosable={false} title='新增属性' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditDeviceProperty deviceId={deviceId} form={form} callBack={this.handCancel} getDeviceInfoById={getDeviceInfoById} {...this.props} />
        </Modal>
      </div>
    );
  }
}

AddDeviceProperty.propTypes = {
  form: PropTypes.any,
  repuestType: PropTypes.string,
  deviceId: PropTypes.number,
  getDeviceInfoById: PropTypes.func
};

export default createForm(AddDeviceProperty);
