import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Form } from 'amos-antd';
import { Select } from 'amos-framework';
import { interfaceDirectionEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import AddEditCapacityInterface from './AddEditCapacityInterface';
import './../device-detail.scss';

const createForm = Form.create();
const Option = Select.Option;
/**
 * 编辑接口
 */
class EditCapacityInterface extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      interfaceOption: [],
      interfaceMap: {}
    };
  }

  componentWillMount(){

  }

  componentDidMount(){
    this.getAllAvailableInterfaces(this.props);
  }

  componentWillReceiveProps(nextProps){
    if ( nextProps.deviceInterfaces !== undefined && (nextProps.deviceInterfaces !== this.props.deviceInterfaces)) {
      this.getAllAvailableInterfaces(nextProps);
    }
  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  getAllAvailableInterfaces = (nextProps) => {
    let interfaceArray = nextProps.deviceInterfaces;
    let interfaceOption = [];
    let interfaceMap = {};
    for (let item of interfaceArray) {
      let optionName = `${item.intfcDisplayName}-${stringUtil(interfaceDirectionEnum,parseInt(item.intfcDirection))}`;
      interfaceOption.push(<Option key={item.intfcId} value={`${item.intfcId}-${item.intfcDirection}`}>{`${item.intfcDisplayName}-${stringUtil(interfaceDirectionEnum, parseInt(item.intfcDirection))}`}</Option>);
      interfaceMap[`${item.intfcId}-${item.intfcDirection}`] = { interfaceMultiName: optionName,interfaceID: item.intfcId,devIntfcID: item.devIntfcID };
    }
    this.setState({ interfaceOption,interfaceMap });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form } = this.props;
    let { interfaceOption,interfaceMap } = this.state;
    return (
      <div className='interface-detail-property-button'>
        <div className='capacity-interface-button' onClick={this.onClick}>
          <img src={require('./../../../../assets/iot/img/list_edit.png')} alt='' />
          <label></label>
        </div>
        <Modal maskClosable={false} title='编辑设备接口' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditCapacityInterface form={form} callBack={this.handCancel} interfaceOption={interfaceOption} interfaceMap={interfaceMap} {...this.props} />
        </Modal>
      </div>
    );
  }
}

EditCapacityInterface.propTypes = {
  form: PropTypes.any,
  deviceInterfaces: PropTypes.array
};

export default createForm(EditCapacityInterface);
