import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Form } from 'amos-antd';
import AddEditCapacityProperty from './AddEditCapacityProperty';
import './../device-detail.scss';

const createForm = Form.create();
/**
 * 编辑采集指标
 */
class EditCapacityProperty extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentWillMount(){

  }

  componentDidMount(){

  }

  componentWillReceiveProps(){

  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form,propertyInfo } = this.props;
    return (
      <div className='interface-detail-property-button' >
        <div className='capacity-property-button' onClick={this.onClick}>
          <img src={require('./../../../../assets/iot/img/list_edit.png')} alt='' />
          <label></label>
        </div>
        <Modal maskClosable={false} title='编辑采集指标' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditCapacityProperty form={form} callBack={this.handCancel} propertyInfo={propertyInfo} {...this.props} />
        </Modal>
      </div>
    );
  }
}

EditCapacityProperty.propTypes = {
  form: PropTypes.any,
  propertyInfo: PropTypes.any
};

export default createForm(EditCapacityProperty);
