import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { AmosFetch } from '../../../../utils/processor';
import { OltSerUrl } from '../../../../consts/urlConsts';
import { Modal,Button,Form } from 'amos-antd';
import { Select } from 'amos-framework';
import AddEditDeviceInterface from './AddEditDeviceInterface';
import './../device-detail.scss';

const createForm = Form.create();
const Option = Select.Option;
/**
 * 编辑接口
 */
class EditDeviceInterface extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      interfaceOption: [],
      interfaceMap: {}
    };
  }
  componentDidMount(){
    this.getAllAvailableInterfaces();
  }

   /**
   * 打开新增对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }


  /**
   *
   *
   * @memberof EditDeviceInterface
   */
  getAllAvailableInterfaces = () => {
    let finalCriterias = [];
    let defaultCriterias = { };
    finalCriterias.push(defaultCriterias);
    AmosFetch.post(OltSerUrl.interfaceDataList,{ data: finalCriterias }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.dataList !== null){
          let interfaceList = data.dataList;
          let interfaceOption = [];
          let interfaceMap = {};
          for (let item of interfaceList) {
            interfaceOption.push(<Option key={item.id} value={`${item.id}`}>{item.name}</Option>);
            interfaceMap[item.id] = item.name;
          }
          this.setState({ interfaceOption,interfaceMap });
        }
      }
    });
  }

  /**
   * 关闭新增对话框
   */
  handCancel = () => {
    this.props.form.resetFields();
    this.setState({ visible: false });
  }

  render() {
    let { form } = this.props;
    let { interfaceOption,interfaceMap } = this.state;
    return (
      <div className='interface-detail-property-button'>
        <div className='device-interface-button' onClick={this.onClick}>
          <img src={require('./../../../../assets/iot/img/list_edit.png')} alt='' />
          <label></label>
        </div>
        <Modal maskClosable={false} title='编辑设备接口' closable visible={this.state.visible} onCancel={this.handCancel} width={500} footer={null} >
          <AddEditDeviceInterface
            interfaceOption={interfaceOption}
            interfaceMap={interfaceMap}
            form={form}
            callBack={this.handCancel}
            {...this.props}
          />
        </Modal>
      </div>
    );
  }
}

EditDeviceInterface.propTypes = {
  form: PropTypes.any
};

export default createForm(EditDeviceInterface);
