import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row,Col,Button } from 'amos-antd';
import CapacityInterface from './CapacityInterface';
import CapacityProperty from './CapacityProperty';
import EditDeviceCapacity from './../deviceAddEdit/EditDeviceCapacity';
import { capacityClassifyEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import './../device-detail.scss';

/**
 * 设备能力单元
 *
 * @class DeviceCapacityCell
 * @extends {Component}
 */
class DeviceCapacityCell extends Component {
  constructor(props) {
    super(props);
    this.state = {
      textEdit: false
    };
  }

  componentDidMount(){

  }

  /**
   * 处理编辑事件
   *
   * @memberof DeviceCapacityCell
   */
  handleEditProperty = (e) => {
    console.log();
  }

  /**
   * 处理新增事件
   *
   * @memberof DeviceCapacityCell
   */
  handleAddProperty = (e) => {
    console.log();
  }

  deleteCurrentDeviceProperty = () => {
    let devicePropertyId = this.props.listInfo.id;
    this.props.deleteCapacityProperty(devicePropertyId);
  }

  render() {
    let { listInfo,deviceId,capacityId,getDeviceInfoById,protocolId,deviceInterfaces,visibility, addCapacityProperty } = this.props;
    return (
      <div className='device-cell-detail'>
        <Row>
          <Col span={24}>
            <div className='device-cell-title'>
              <label style={{ color: 'black',marginLeft: '2rem',fontSize: '14px' }}>名称</label>
              <label style={{ color: 'black',fontSize: '14px' }}>：{listInfo.name}</label>
              {visibility===1?
                <EditDeviceCapacity
                capacityId={capacityId}
                deviceInterfaces={deviceInterfaces}
                deviceId={deviceId}
                listInfo={listInfo}
                protocolId={protocolId}
                getDeviceInfoById={getDeviceInfoById}
                deleteCurrentDeviceProperty={this.deleteCurrentDeviceProperty}
                {...this.props}
              />
              :null}

            </div>
            <div className='device-cell-content-basic'>
              <Row>
                <Col span={12} style={{ marginLeft: '2rem' }} >
                  <label className='device-title-name'>分类：</label><label className='device-title-value'>{stringUtil(capacityClassifyEnum,listInfo.type)}</label>
                  <label className='device-title-name' style={{ marginLeft: '3rem' }}>通信协议：</label><label className='device-title-value'>{listInfo.protocolName}</label>
                  <label className='device-title-name' style={{ marginLeft: '3rem' }}>描述：</label><label className='device-title-value'>{listInfo.descr}</label>
                </Col>
              </Row>
            </div>
            <Row style={{ height: '100%' }}>
              <Col style={{ height: '100%' }} span={24}>
                <CapacityInterface protocolId={protocolId} capacityId={capacityId} getDeviceInfoById={getDeviceInfoById} deviceId={deviceId} visibility={visibility} interfaceInfo={listInfo.interfaceInfo} deviceInterfaces={deviceInterfaces} />
              </Col>
            </Row>
            <Row style={{ height: '100%' }}>
              <Col style={{ height: '100%' }} span={24}>
                <CapacityProperty capacityId={capacityId} addCapacityProperty={addCapacityProperty} getDeviceInfoById={getDeviceInfoById} deviceId={deviceId} visibility={visibility} propertyInfo={listInfo.propertyInfo} />
              </Col>
            </Row>
          </Col>
        </Row>
      </div>
    );
  }
}

DeviceCapacityCell.propTypes = {
  deleteCapacityProperty: PropTypes.func,
  addCapacityProperty:  PropTypes.func,
  listInfo: PropTypes.object,
  deviceId: PropTypes.number,
  key: PropTypes.number,
  capacityId: PropTypes.number,
  getDeviceInfoById: PropTypes.func,
  deviceInterfaces: PropTypes.array,
  protocolId: PropTypes.number
};

export default DeviceCapacityCell;
