import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row,Col,Popover } from 'amos-antd';
import EditDeviceInterface from './../deviceAddEdit/EditDeviceInterface';
import { interfaceDirectionEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import './../device-detail.scss';

/**
 * 设备接口单元
 *
 * @class DeviceInterfaceCell
 * @extends {Component}
 */
class DeviceInterfaceCell extends Component {
  constructor(props) {
    super(props);
    this.state = {
      textEdit: false
    };
  }

  componentDidMount(){

  }

  /**
   * 处理编辑事件
   *
   * @memberof DeviceInterfaceCell
   */
  handleEditProperty = (e) => {
    console.log();
  }

  /**
   * 处理新增事件
   *
   * @memberof DeviceInterfaceCell
   */
  handleAddProperty = (e) => {

  }

  deleteCurrentDeviceInterface = () => {
    let devicePropertyId = this.props.propertyInfo.devIntfcID;
    this.props.deleteInterfaceProperty(devicePropertyId);
  }

  render() {
    let { propertyInfo,visibility } = this.props;
    return (
      <div className='device-cell-detail'>
        <Row>
          <Col span={24}>
            <div className='device-cell-title'>
              <div className='device-cell-title-text'>{propertyInfo.intfcDisplayName}</div>
              {visibility ===1?<span>
                <EditDeviceInterface {...this.props} />
                <div className='device-cell-delete-button' onClick={this.deleteCurrentDeviceInterface}>
                  <img src={require('./../../../../assets/iot/img/mk_delect.png')} alt='' />
                  <label />
                </div>
              </span>:null}
            </div>
            <div className='device-cell-content'>
              <div>
                <Popover placement="top" title={'设备接口：'} content={propertyInfo.intfcDisplayName} >
                  <div className='single-info'>设备接口：{propertyInfo.intfcDisplayName}</div>
                </Popover>
              </div>
              <div>
                <div className='single-info'>方向：{stringUtil(interfaceDirectionEnum,propertyInfo.intfcDirection)}</div>
              </div>
            </div>
          </Col>
        </Row>
      </div>
    );
  }
}

DeviceInterfaceCell.propTypes = {
  deleteInterfaceProperty: PropTypes.func,
  propertyInfo: PropTypes.object,
  key: PropTypes.number
};

export default DeviceInterfaceCell;
