import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row,Col,Popover } from 'amos-antd';
import EditDeviceProperty from './../deviceAddEdit/EditDeviceProperty';
import { classifyEnum,dataTypeEnum } from  './../../common/DeviceEnum';
import { stringUtil } from './../../common/DeviceLang';
import './../device-detail.scss';

/**
 * 设备属性单元
 *
 * @class DevicePropertyCell
 * @extends {Component}
 */
class DevicePropertyCell extends Component {
  constructor(props) {
    super(props);
    this.state = {
      textEdit: false
    };
  }

  componentDidMount(){

  }

  /**
   * 处理编辑事件
   *
   * @memberof DevicePropertyCell
   */
  handleEditProperty = (e) => {
    console.log();
  }

  /**
   * 处理新增事件
   *
   * @memberof DevicePropertyCell
   */
  handleAddProperty = (e) => {
    console.log();
  }

  deleteCurrentDeviceProperty = () => {
    let devicePropertyId = this.props.propertyInfo.id;
    this.props.deleteDeviceProperty(devicePropertyId);
  }

  /**
   * type: 1表示变量，2表示常量，3表示标签，4输出
   * dataType:1表示整型，2表示浮点型，3表示布尔型，4表示枚举，5表示字符串，6表示密码
   */
  getDataContent = (propertyInfo) => {
    let { type,dataType } = propertyInfo;
    let htmlContent = [];
    if ((type === 1 || type === 4) && (dataType === 1 || dataType === 2))
    {
      htmlContent.push(<div>
        <label>最大值：{propertyInfo.maxValue}</label>
        <div>最小值：{propertyInfo.minValue}</div>
      </div>);
    } else if (dataType === 4 && type !== 3)
    {
      htmlContent.push(<div>
        <Popover placement="top" title={'枚举范围：'} content={propertyInfo.enumRange} >
        <label>枚举范围：{propertyInfo.enumRange}</label>
        </Popover>
      </div>);
    } else if (type === 3)
    {
      htmlContent.push(<div>
        <label>单位：{propertyInfo.unit}</label>
      </div>);
    } else if (type === 1)
    {
      if (dataType === 3) {
        let bolValue = String(Boolean(parseInt(propertyInfo.valueStr)));
        htmlContent.push(<div>
          <Popover placement="top" title={'默认值：'} content={bolValue} >
            <div>默认值：{bolValue}</div>
          </Popover>
        </div>);
      } else {
        htmlContent.push(<div>
          <Popover placement="top" title={'默认值：'} content={propertyInfo.valueStr} >
            <div>默认值：{propertyInfo.valueStr}</div>
          </Popover>
        </div>);
      }
    } else if (type === 2)
    {
      htmlContent.push(<div>
        <label>数值：{propertyInfo.valueStr}</label>
      </div>);
    } else {
      htmlContent.push(<div>
        <label>单位：{propertyInfo.unit}</label>
      </div>);
    }
    return htmlContent;
  }

  render() {
    let { propertyInfo,visibility } = this.props;
    return (
      <div className='device-cell-detail'>
        <Row>
          <Col span={24}>
            <div className='device-cell-title'>
              <div className='device-cell-title-text'>{propertyInfo.displayName}</div>
              {visibility===1?
              <span>
                <EditDeviceProperty {...this.props} />:null}
                <div className='device-cell-delete-button' onClick={this.deleteCurrentDeviceProperty}>
                  <img src={require('./../../../../assets/iot/img/mk_delect.png')} alt='' />
                  <label></label>
                </div>
                </span>
                :null}


            </div>
            <div className='device-cell-content'>
              <div>
                <Popover placement="top" title={'属性名：'} content={propertyInfo.name} >
                  <label>属性名：{propertyInfo.name}</label>
                </Popover>
                <Popover placement="top" title={'显示名称：'} content={propertyInfo.displayName} >
                  <div>显示名称：{propertyInfo.displayName}</div>
                </Popover>
              </div>
              <div>
                <div className='single-info'>分类：{stringUtil(classifyEnum,propertyInfo.type)}</div>
              </div>
              <div>
                <div className='single-info'>数据类型：{stringUtil(dataTypeEnum,propertyInfo.dataType)}</div>
              </div>
              {this.getDataContent(propertyInfo)}
              <div>
                <Popover placement="top" title={'说明：'} content={propertyInfo.descr} >
                  <div className='single-info'>说明：{propertyInfo.descr}</div>
                </Popover>
              </div>
            </div>
          </Col>
        </Row>
      </div>
    );
  }
}

DevicePropertyCell.propTypes = {
  deleteDeviceProperty: PropTypes.func,
  propertyInfo: PropTypes.object,
  key: PropTypes.number
};

export default DevicePropertyCell;
