import React, { Component } from 'react';
//import PropTypes from 'prop-types';
import { Tabs } from 'amos-antd';
import { AmosFetch } from '../../utils/processor';
import OltSerUrl from '../../consts/urlConsts';
import PublicProtocol from './publicProtocol';
import PrivateProtocol from './privateProtocol';
import PrivateProtocolDetail from './privateProtocol/PrivateProtocolDetail';
import AddProtocol from './addProtocol';
import SearchBar from './common/searchBar';
import './../common/style/commonTabs.scss';
import './../common/style/commonStyle.scss';

const TabPane = Tabs.TabPane;

/**
 * 设备协议管理
 *
 * @class DeviceProtocol
 * @extends {Component}
 */
class DeviceProtocol extends Component {
  constructor(props) {
    super(props);
    let activeKey = '1';
    const newLocal = this.props.location;
    if (newLocal.query.activeKey){
      activeKey = newLocal.query.activeKey;
    }
    this.state = {
      //查询条件list，默认为空
      criterias: [],
      //下拉框数据集合，默认为空
      scriptLangOptions: [],
      //界面标记，当前选中的界面标记
      flag: activeKey,
      //公有或私有标记，'0' 公有 '1' 私有 默认为'0'
      visibility: '0',
      //界面数据集合
      dataList: [],
      tabContent: [],
      privateTabContent: [],
      activeKey
    };
  }

  componentWillMount() {
    AmosFetch.get(OltSerUrl.scriptLangType).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        let scriptLangDatas = [];
        data ? data.dataList.map(e=>{
          scriptLangDatas.push({ value: e.id,label: e.name,selected: false,style: 'all-filter-btn' });
        }) : [];
        this.setState({ scriptLangOptions: scriptLangDatas });
      }
    });
    this.requestMethod(this.state.activeKey === '1' ? '0' : '1',[]);
  }

  onTabClick = (value) =>{
    if ( value === '1'){
      this.requestMethod('0',this.state.criterias,undefined,value);
    } else if (value === '2'){
      this.requestMethod('1',this.state.criterias,undefined,value);
    }
  }

  setSelected = (record) => {
    this.selected = record;
  }

  showTabPane = (flag) => {
    let { scriptLangOptions,criterias,dataList } = this.state;
    let selected = this.selected;
    let res = [];
    switch (flag) {
      case '1': //公共协议
        res.push(<PublicProtocol key={1} setSelected={this.setSelected} dataList={dataList} requestMethod={this.requestMethod} updateAddView={this.updateAddView} criterias={criterias} visibility='0' />);
        break;
      case '2': //私有协议
        res.push(<PrivateProtocol key={2} setSelected={this.setSelected} dataList={dataList} requestMethod={this.requestMethod} updateAddView={this.updateAddView} criterias={criterias} visibility='1' />);
        break;
      case '3': //协议详情
        res.push(<PrivateProtocolDetail key={3} scriptLangOptions={scriptLangOptions} selected={selected} setSelected={this.setSelected} />);
        break;
      case '4': //协议新增
        res.push(<AddProtocol key={4} updateAddView={this.updateAddView} />);
        break;
      default:res.push(<PublicProtocol key={1} setSelected={this.setSelected} updateAddView={this.updateAddView} criterias={criterias} visibility='0' />);
        break;
    }
    return res;
  }


   /**
   * 查询条件封装，向后端发起请求获取结果
   * @param {string} visibility 目前所处页面属于私有或者公有
   * @param {list} criterias 查询条件
   * @param {string} flagValue 原界面标记
   * @param {string} value 查询私有还是公有数据
   */
  requestMethod = (visibility,criterias,flagValue,value) => {
    let defaultCriterias = { name: 'visibility',type: 'EQUAL',value: visibility };
    let newCriterias = [];
    if (criterias.length > 0){
      for (let i = 0; i < criterias.length; i++) {
        let data = criterias[i];
        if (data.type !== 'EQUAL'){
          newCriterias.push(data);
        }
      }
      criterias = newCriterias;
    }
    criterias.push(defaultCriterias);
    AmosFetch.post(OltSerUrl.protocolDataList,{ data: criterias }).then(res => {
      if (res.ok) {
        return res.json();
      }
      else
      {
        throw new Error('从服务端获取数据失败！');
      }
    }).then((data)=>{
      if (data.result === 'SUCCESS'){
        if (data.dataList !== null){
          this.setState({ dataList: data.dataList });
        }
      } else {
        this.setState({ dataList: [] });
      }
      //
      let tabContent = [];
      let privateTabContent = [];
      let { criterias } = this.state;
      if (flagValue) {
        this.setState({ flag: flagValue });
      }
      if (value) {
        this.setState({
          flag: value,
          criterias: [],
          visibility,
          activeKey: value
        });
      }
      let activeKey = this.state.activeKey;
      if (activeKey === '1'){
        tabContent.push(<PublicProtocol key={1} setSelected={this.setSelected} dataList={data.dataList} requestMethod={this.requestMethod} updateAddView={this.updateAddView} criterias={criterias} visibility='0' />);
        this.setState({
          tabContent
        });
      } else if (activeKey === '2') {
        privateTabContent.push(<PrivateProtocol key={2} setSelected={this.setSelected} dataList={data.dataList} requestMethod={this.requestMethod} updateAddView={this.updateAddView} criterias={criterias} visibility='1' />);
        this.setState({
          privateTabContent
        });
      }
    });
  }

  updateAddView=(flag)=>{
    if (flag === '2'){
      this.requestMethod(this.state.visibility,this.state.criterias,flag);
    } else {
      let activeKey = this.state.activeKey;
      if (activeKey === '1'){
        this.setState({ flag,tabContent: this.showTabPane(flag) });
      } else if (activeKey === '2') {
        this.setState({ flag,privateTabContent: this.showTabPane(flag) });
      }
    }
  }

  handleCriterias=(criterias)=>{
    let { visibility } = this.state;
    this.setState({ criterias });
    this.requestMethod(visibility,criterias);
  }

  render() {
    let { scriptLangOptions,activeKey,privateTabContent,tabContent } = this.state;
    return (
      <div className='tabs-outside'>
        <Tabs
          activeKey={activeKey}
          onTabClick={this.onTabClick}
          tabBarExtraContent={<SearchBar handleCriterias={this.handleCriterias} scriptLangOptions={scriptLangOptions} />}
        >
          <TabPane tab={<div>公共</div>} key="1">
            {tabContent}
          </TabPane>
          <TabPane tab={<div>我的</div>} key="2">
            {privateTabContent}
          </TabPane>
        </Tabs>
      </div>
    );
  }
}

DeviceProtocol.propTypes = {

};

export default DeviceProtocol;
