import React, { Component } from 'react';
import { Form,Input,Row,Col,Icon } from 'amos-antd';
import PropTypes from 'prop-types';

const createForm = Form.create();
const FormItem = Form.Item;
const { TextArea } = Input;

/**
 * 协议基本测试界面
 */
class ProtocolTestView extends Component {
  constructor(props) {
    super(props);
    this.state = {
      activeKey: '1', //默认打开新建接口面板
      interfaceProList: [], //新建属性数据集合
      itemInfo: {}, //新建接口输入需要向后台提交保存的数据
      paramView: []
    };
  }

  //动态生成增加参数的视图
  addParamView =() =>{
    let paramView = this.state.paramView;

    let key = 1;
    if (paramView.length > 0){
      key = parseInt(paramView[paramView.length - 1].key) + 1;
    }
    paramView.push(<Row key={key}>
      <Col span={10}>
        <FormItem label='s' labelCol={{ span: 4 }} wrapperCol={{ span: 18 }} >
          <Input />
        </FormItem>
      </Col>
      <Col span={10}>
        <FormItem label='m' labelCol={{ span: 4 }} wrapperCol={{ span: 18 }} >
          <Input />
        </FormItem>
      </Col>
      <Col span={4}>
        <a onClick={()=>this.deleteParamView(key)}><Icon type='close-circle-o' style={{ fontSize: 25, color: '#08c' }} /></a>
      </Col>
    </Row>);
    this.setState({
      paramView
    });
  }

  //删除视图
  deleteParamView = (e) => {
    let paramView = this.state.paramView;
    for (let i = 0; i < paramView.length; i++) {
      let data = paramView[i];
      if (e === parseInt(data.key)){
        paramView.splice(i,1);
        break;
      }
    }
    this.setState({
      paramView
    });
  }

  render() {
    return (
      <div>
        <Row>
          <Col span={24}>
            <FormItem label='应答数据' labelCol={{ span: 8 }} wrapperCol={{ span: 8 }} >
              <TextArea autosize={{ minRows: 4, maxRows: 10 }} />
            </FormItem>
          </Col>
        </Row>
        <Row>
          <Col span={24}>
            <FormItem label='超时' labelCol={{ span: 8 }} wrapperCol={{ span: 3 }} >
              <Input />
            </FormItem>
          </Col>
        </Row>
        <Row>
          <Col span={24}>
            <FormItem label='参数' labelCol={{ span: 8 }}  wrapperCol={{ span: 8 }} >
              <Row>
                <Col span={10}>
                  <FormItem label='s' labelCol={{ span: 4 }} wrapperCol={{ span: 18 }} >
                    <Input />
                  </FormItem>
                </Col>
                <Col span={10}>
                  <FormItem label='m' labelCol={{ span: 4 }} wrapperCol={{ span: 18 }} >
                    <Input />
                  </FormItem>
                </Col>
                <Col span={4}>
                  <a onClick={this.addParamView} ><Icon type='plus-circle-o' style={{ fontSize: 25, color: '#08c' }} /></a>
                </Col>
              </Row>
              {
                this.state.paramView
              }
            </FormItem>
          </Col>
        </Row>

      </div>
    );
  }
}

ProtocolTestView.propTypes = {
  form: PropTypes.any,
  updateAddView: PropTypes.func
};

export default createForm(ProtocolTestView);
