import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form,Modal,Row,Col } from 'amos-antd';

const createForm = Form.create();
/**
 *
 * @class AlarmDetail
 * @extends {Component}
 */
class AlarmDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  //点击事件
  onClick = () => {
    this.setState({ visible: true });
  }

  //取消功能
  handleCancel = (obj) => {
    this.setState({ visible: false });
  }

  render() {
    let { alarmInfo,clearAlarm } = this.props;
    let { name,level,status,type,durationDate,count,descr } = alarmInfo;
    return (
      <div className='alarm-detail-root' >
        <label onClick={this.onClick} >详情</label>
        <Modal className='alarm-detail-modal' title='告警详情' visible={this.state.visible} onCancel={this.handleCancel} footer={null} width={700}>
          <div className='alarm-detail-content'>
            <Row>
              <Col className='alarm-detail-source-name' span={5}>
                告警源:
              </Col>
              <Col className='alarm-detail-source-value' span={19}>
                {name}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-descr-name' span={5}>
                描述:
              </Col>
              <Col title={descr} className='alarm-detail-descr-value' span={19}>
                {descr}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-level-name' span={5}>
                告警级别:
              </Col>
              <Col className='alarm-detail-level-value' span={19}>
                {level === 1 ? '一级' : level === 2 ? '二级' : '三级'}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-type-name' span={5}>
                告警类型:
              </Col>
              <Col className='alarm-detail-type-value' span={19}>
                {type === 1 ? '指标越界' : type === 2 ? '采集异常' : '设备掉线'}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-status-name' span={5}>
                状态:
              </Col>
              <Col className='alarm-detail-status-value' span={19}>
                {status === 1 ? '未处理' : status === 2 ? '历史告警' : '已删除'}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-duration-name' span={5}>
                持续时间:
              </Col>
              <Col className='alarm-detail-duration-value' span={19}>
                {durationDate}
              </Col>
            </Row>
            <Row>
              <Col className='alarm-detail-count-name' span={5}>
                告警次数:
              </Col>
              <Col className='alarm-detail-count-value' span={19}>
                {count}
              </Col>
            </Row>
            <Row style={{ 'padding-top': '15px' }}>
              <Col className='alarm-detail-clear' span={4} offset={20} onClick={clearAlarm}>
                删除
              </Col>
            </Row>
          </div>
        </Modal>
      </div>
    );
  }
}

AlarmDetail.propTypes = {
  form: PropTypes.any,
  alarmInfo: PropTypes.any,
  clearAlarm: PropTypes.func
};

export default createForm(AlarmDetail);
