import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button, Upload, message, Icon } from 'amos-framework';
import { IecUrl } from '../../../consts/urlConsts';
import { compleHeaders } from '../../../utils/request';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
/**
 * 工具栏
 *
 * @class ToolBar
 * @extends {Component}
 */

class ToolBar extends Component {
  constructor(props){
    super(props);
    this.state = {};
  }

  componentWillMount(){

  }

  onClick =(e,value)=>{
    let { onButtonClick } = this.props;
    onButtonClick(value);
  }
  


  render() {
    const props = {
      name: 'file',
      action: formatUrl(IecUrl.iecImportUrl, { serviceId: this.props.serviceId, pointType: this.props.pointType }),
      showUploadList: false,
      headers: compleHeaders(),
      onChange(info) {
      if (info.file.status !== 'uploading') {
        console.log(info.file, info.fileList);
      }
      if (info.file.status === 'done') {
        message.success(`${info.file.name} 上传成功`);
        this.props.reload();
      } else if (info.file.status === 'error') {
        message.danger(`${info.file.name} 上传失败`);
      }
      }
    }
    return (
      <div  className='risk-lever-toolbar'>
        <div className='risk-lever-button' >
          <Button title='添加' icon={<Icon icon="add-noborder" />} transparent onClick={e => this.onClick(e,'point-1')} />
          <Button title='删除' icon={<Icon icon="delete" />} transparent onClick={e => this.onClick(e, 'point-2')} />
          <Button title='编辑' icon={<Icon icon="edit" />} transparent onClick={e => this.onClick(e,'point-3')} />
          <Upload {...props}><Button title='导入' icon={<Icon icon="upload" />} transparent /></Upload>
          <Button title='清空' icon={<Icon icon="hdd" />} transparent onClick={e => this.onClick(e,'point-5')} />
          <Button title='下载模板' icon={<Icon icon="download" />} transparent onClick={e => this.onClick(e,'point-6')} />
        </div>
      </div>
    );
  }
}

ToolBar.propTypes = {
  onButtonClick: PropTypes.func,
  pointType: PropTypes.string,
  serviceId: PropTypes.string,
  reload: PropTypes.func
};

export default ToolBar;