import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Form } from 'amos-antd';


const FormItem = Form.Item;
const createForm = Form.create();
const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 5 }
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 16 }
  }
};
/**
 *
 * @class AlarmDetail
 * @extends {Component}
 */
class AlarmDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    };
  }

  componentDidMount(){

  }

  onClick = () => {
    this.setState({ visible: true });
  }

  handleCancel = (obj) => {
    this.setState({ visible: false });
  }

  render() {
    let { alarmInfo } = this.props;
    let { name,level,status,type,durationDate,count,descr } = alarmInfo;
    return (
      <span>
        <div>
          <Form horizontal>
            <FormItem {...formItemLayout} label='告警源: '>
              <span>{name}</span>
            </FormItem>
            <FormItem {...formItemLayout} label='描述: '  >
              <span>{descr}</span>
            </FormItem>
            <FormItem {...formItemLayout} label='告警级别: '  >
              <span>{level === 1 ? '一级' :  level === 2 ? '二级' : '三级'}</span>
            </FormItem>
            <FormItem {...formItemLayout} label='告警类型：'  >
              <span>{type === 1 ? '指标越界' :  type === 2 ? '采集异常' : '设备掉线'}</span>
            </FormItem>
            <FormItem {...formItemLayout} label='状态: '  >
              <span>{status === 1 ? '未处理' :  status === 2 ? '历史告警' : '已删除'}</span>
            </FormItem>
            <FormItem {...formItemLayout} label='持续时间: '  >
              <span>{durationDate}</span>
            </FormItem>
            <FormItem {...formItemLayout} label='告警次数: '  >
              <span>{count}</span>
            </FormItem>
          </Form>
        </div>
      </span>
    );
  }
}

AlarmDetail.propTypes = {
  form: PropTypes.any,
  alarmInfo: PropTypes.any
};

export default createForm(AlarmDetail);
