import React, { Component } from 'react';
import PropTypes from 'prop-types';

import { browserHistory } from 'amos-react-router';
import { Button } from 'amos-framework';
import AlarmInfoCell from './AlarmInfoCell';

class AlarmTools extends Component {

  static propTypes = {
    dataList: PropTypes.any,
    onHide: PropTypes.func
  };

  static defaultProps = {
  };

  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      dataList: [{ name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' },
      { name: '设备掉线告警',descr: '设备掉线告警：设备掉线，采集数据异常',date: '018-05-01 00:06:05' }]
    };
  }

  componentWillMount() {

  }

  onClick = () =>{
    this.props.onHide();
    browserHistory.push('/main/monitor/alarmManage/recentAlarm');
  }

  detailAlarm = () =>{
    this.props.onHide();
    this.setState({ visible: true });
  }

  handleCancel = (obj) => {
    this.setState({ visible: false });
  }

  creatViewByList = () =>{
    let view = [];
    let { dataList } = this.props;
    let i = 1;
    if ( dataList && dataList.length > 0 ){
      dataList.map(data => {
        let numb = '10';
        if (i < 10){
          numb = `0${i}`;
        }
        let level = data.level;
        let className = '';
        if (level === 3){
          className = 'cell-alarm-info-three';
        } else if (level === 2){
          className = 'cell-alarm-info-two';
        } else {
          className = 'cell-alarm-info-one';
        }
        view.push(<AlarmInfoCell key={data.id} data={data} numb={numb} className={className} {...this.props} />);
        i = i + 1;
      });
    }
    return view;
  }
  render() {
    return (
      <div className='ant-popover-context' >
        {
          this.creatViewByList()
        }
        <div className='bottem-button-css' >
          <Button onClick={this.onClick} >查看更多</Button>
        </div>
      </div>
    );
  }
}

export default AlarmTools;
