import React, { Component } from 'react';
import { browserHistory } from 'amos-react-router';
import { utils, Store } from 'amos-tool';
import { Connect } from 'amos-framework';
import PropTypes from 'prop-types';
import { Link } from 'amos-react-router';
import { Menu, Icon } from 'amos-antd';
import { PubSub } from 'ray-eventpool';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import * as endConf from 'amos-processor/lib/config/endconf';
// import storageConsts, { CONSTS } from './../../consts/storageConsts';
import { secExtUrl } from './../../consts/urlConsts';
import { pathMapping } from './../../routes/customRoutes';
import MainFrame from '../common/mainframe';
import { STATICTICS_JUMP_TOPIC } from './../zonglan/home/statistics/modelConf/nodeConf';
import AlarmTools from './extratools/AlarmTools';
import Help from './extratools/Help';
import { analysis } from '../../consts/outterUrlConsts';

import '../../styles/view/mainframe/mainframe.scss';

const enhanceStorage = Connect.enhanceStorage;
const lsTool = Store.lsTool;
const AmosConfig = endConf.AmosConfig;
const loginURI = AmosConfig.httpURI.loginURI;

const MenuItem = Menu.Item;

// @enhanceStorage({
//   storageItems: storageConsts(CONSTS)
// })
class RootView extends Component {

  constructor(props) {
    super(props);
    this.state = {
      siderMenusList: [],
      selectedSubMenuKey: ''
    };
  }

  componentDidMount() {
    // this.pubsub_jump = PubSub.subscribe(STATICTICS_JUMP_TOPIC.staticticsJump, (e,{ parentKey,childkey }) => {
    //   const { extendSystem } = this.state;
    //   const parentNode = extendSystem.filter(e=>e.key === parentKey);
    //   if (parentNode.length === 1) {
    //     this.setState({
    //       siderMenusList: parentNode[0].children,
    //       selectedSubMenuKey: childkey
    //     });
    //   }
    // });
  }

  componentWillUnmount() {
    // PubSub.unsubscribe(this.pubsub_jump);
  }

  onOpenDefaultPage = (menus) => {
    // open first url
    if (location.pathname === '/main'){
      const item = menus.filter(e => e.url)[0] || {};
      if (!utils.isEmpty(item)){
        if (item.url){
          browserHistory.push(item.url);
          this.setState({ siderMenusList: item.children || [] });
        }
      }
    }
  }

  getFrameConfig = () => {
    return {
      opSearchMenusUrl: formatUrl(secExtUrl.opSearchMenusUrl),
      defaultLink: '/biz',
      loginLink: this.login
    };
  };

  getSysToolProps = () => {
    return {
      userPic: require('./../../assets/user/normal.png'),
      loginOutUrl: secExtUrl.loginOutUrl,
      userInfoLink: '/main/securityConfig',
      // extraTools: this.renderExtraTools(),
      // externalSub: this.renderExtraSub(),
      userExtra: true
    };
  }

  login = () => {
    window.location.href = loginURI;
  }

  clickTestMenu = () => {

  }

  // renderExtraTools = () => {
  //   return [
  //     <MenuItem key="in" onClick={this.clickTestMenu}><AlarmTools /></MenuItem>,
  //     <MenuItem key="out" onClick={this.clickTestMenu}><Help /></MenuItem>
  //   ];
  // }

  renderExtraSub = () => {
    let analysisUrl = analysis();
    return [
      <div key="extra-1" className="amos-dropnav-item extra-temp-style"><a href={analysisUrl} target="_blank">数据分析</a></div>
    ];
  }

  render() {
    const frameConfig = this.getFrameConfig();
    const sysToolPorps = this.getSysToolProps();
    const { siderMenusList, selectedSubMenuKey } = this.state;
    return (
      <MainFrame
        {...frameConfig}
        onMenuLoadCompleted={this.openDefaultPage}
        sysToolPorps={sysToolPorps}
        siderMenusList={siderMenusList}
        selectedSubMenuKey={selectedSubMenuKey}
        menuWidth="160px"
        {...this.props}
      />
    );
  }
}

RootView.propTypes = {

};

export default RootView;
