import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button, Icon} from 'amos-framework';

/**
 * 工具栏
 *
 * @class ToolBar
 * @extends {Component}
 */

class ToolBar extends Component {
  constructor(props){
    super(props);
    this.state = {};
  }

  componentWillMount(){

  }

  onClick =(e,value)=>{
    let { onButtonClick } = this.props;
    onButtonClick(value);
  }


  render() {
    return (
      <div  className='risk-lever-toolbar'>
        <div className='risk-lever-button' >
          <Button title='添加' icon={<Icon icon="add" />} transparent onClick={e => this.onClick(e,'point-1')} />
          <Button title='删除' icon={<Icon icon="delete" />} transparent onClick={e => this.onClick(e, 'point-2')} />
          <Button title='编辑' icon={<Icon icon="edit" />} transparent onClick={e => this.onClick(e,'point-3')} />
        </div>
      </div>
    );
  }
}

ToolBar.propTypes = {
  onButtonClick: PropTypes.func,
  parent: PropTypes.any
};

export default ToolBar;