import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal,Button,Row,Col,Input } from 'amos-antd';

/**
 *
 * @class SingleClearAlarm
 * @extends {Component}
 */
class SingleClearAlarm extends Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false,
      inputStr: '告警已处理！'
    };
  }
  /**
   * 初始化
   */
  componentDidMount() {

  }

  /**
   * 打开新增监测规则对话框
   */
  onClick = () => {
    this.setState({ visible: true });
  }

  onChange = (e) =>{
    this.setState({
      inputStr: e.target.value
    });
  }
  /**
   * 关闭新增监测规则对话框
   */
  handleCancel = () => {
    this.setState({ visible: false });
  }

  handleSubmit = () => {
    this.handleCancel();
    let ids = [];
    ids.push(this.props.alarmId);
    this.props.clearAlarm(this.state.inputStr,ids);
  }

  render() {
    let destroyOnClose = true;
    let maskClosable = false;
    let { inputStr } = this.state;
    return (
      <div className='clear-alarm' title='批量清除'>
        <label onClick={this.onClick} >清除</label>
        <Modal width={333} className='clear-alarm-modal' title='清除告警信息' visible={this.state.visible}  footer={null} onCancel={this.handleCancel} maskClosable={maskClosable} destroyOnClose={destroyOnClose} >
          <div>
            <Row style={{ marginTop: '20px',textAlign: 'center' }} >
              <Col span={24}>
                <span style={{ 'font-size': '13px' }}>备注：</span><Input value={inputStr} style={{ width: '250px','font-size': '13px' }} onChange={this.onChange} />
              </Col>
            </Row>
          </div>
          <Row style={{ 'padding-top': '30px' }}>
            <Col className='alarm-detail-clear' span={4} offset={6} onClick={this.handleSubmit}>
              确定
            </Col>
            <Col className='alarm-detail-cancel' span={4} offset={2} onClick={this.handleCancel}>
              取消
            </Col>
          </Row>
        </Modal>
      </div>
    );
  }
}

SingleClearAlarm.propTypes = {
  title: PropTypes.any,
  clearAlarm: PropTypes.func,
  alarmId: PropTypes.string
};

SingleClearAlarm.defaultProps = {
};
export default SingleClearAlarm;
