import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { utils } from 'amos-tool';
import { Button, Form, Input } from 'amos-framework';

const FormItem = Form.Item;
const FormFooter = Form.Footer;
const TextArea = Input.TextArea;
const formItemLayout = {
  labelCol: {
    xs: { span: 10 },
    sm: { span: 6 },
    className: 'colspanlab'
  },
  wrapperCol: {
    xs: { span: 14 },
    sm: { span: 18 },
    className: 'colspan'
  }
};

/**
 * 新增规则
 *
 * @class CreateLibForm
 * @extends {Component}
 */
class CreateLibForm extends Component {

  static propTypes = {
    form: PropTypes.any,
    onSave: PropTypes.func,
    libObj: PropTypes.object,
    cancelAction: PropTypes.func
  };

  static defaultProps = {
    onSave(){},
    libObj: {}
  };

  constructor(props) {
    super(props);
    const { libObj } = props;
    this.state = {
      form: {
        name: libObj.name || '',
        descr: libObj.descr || ''
      },
      rules: {
        name: [
          { required: true, message: '规则名称不能为空' },
          { min: 1,max: 150, message: '长度范围：1-150！' }
        ],
        descr: [
          { required: false },
          { min: 0,max: 150, message: '长度范围：0-150！' }
        ]
      }
    };
  }

  componentWillReceiveProps(nextProps) {
    if (!utils.isEmpty(nextProps.libObj)){
      this.setState({
        name: nextProps.libObj.name || '',
        descr: nextProps.libObj.descr || ''
      });
    }
  }

  onChange = (key, e) => {
    const { form } = this.state;
    const value = e.target.value;
    form[key] = value;
    this.setState({ form });
  }

  handleSubmit = (e) => {
    e.preventDefault();
    this.form.validate((valid, dataValues) => {
      console.log('返回内容:', dataValues, valid);
      if (valid) {
        // 执行保存
        let id = this.props.libObj.id;
        if (id !== undefined) {
          Object.assign(dataValues,{ id });
        }
        this.props.onSave(dataValues);
      } else {
        console.log('error submit!!');
        return false;
      }
    });
  }

  render() {
    const { form, rules } = this.state;
    const innerStyle = { width: 230 };

    return (
      <Form style={{ width: 350 }} className="create-libaray" ref={component => this.form = component} model={form} rules={rules}>
        <FormItem label={<span>规则名称</span>} field="name" {...formItemLayout} >
          <Input
            value={form.name}
            style={innerStyle}
            placeholder="请输入规则名称"
            onChange={(e) => this.onChange('name', e)}
          />
        </FormItem>
        <FormItem label="规则描述" field="descr" {...formItemLayout} >
          <TextArea
            rows={4}
            value={form.descr}
            style={innerStyle}
            placeholder="请输入规则描述"
            onChange={(e) => this.onChange('descr', e)}
          />
        </FormItem>
        <FormFooter>
          <div className='create-cancel-btn' onClick={this.props.cancelAction}>取消</div>
          <div className='create-submit-btn' onClick={this.handleSubmit}>提交</div>
        </FormFooter>
      </Form>
    );
  }
}

export default CreateLibForm;
