import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Switch,Row,Col,Modal } from 'amos-framework';
import classnames from 'classnames';
import Icon from 'amos-icon';

class LibItem extends Component {

  static propTypes = {
    title: PropTypes.string,
    descr: PropTypes.string,
    enable: PropTypes.bool,
    published: PropTypes.bool,
    toggleUse: PropTypes.func,
    togglePublish: PropTypes.func,
    onDoubleClick: PropTypes.func,
    showClose: PropTypes.bool,
    showSetting: PropTypes.bool,
    onRemove: PropTypes.func,
    onSetting: PropTypes.func
  };

  static defaultProps = {
    showClose: true,
    showSetting: true
  };

  constructor(props) {
    super(props);
  }

  renderOperater = () => {
    const { toggleUse, togglePublish, enable, published, onSetting } = this.props;
    return (
      <div className="item-content-operate">
        <Switch
          className="obj-publish-switch"
          onLabel="已发布"
          offLabel="调试中"
          onChange={togglePublish}
          onOff={published}
        />
        <Switch
          className="obj-startuse-switch"
          onLabel="已启用"
          offLabel="未启用"
          onChange={toggleUse}
          onOff={enable}
        />
      </div>
    );
  }

  renderRuleOperate = () => {
    let { toggleUse, togglePublish,onDoubleClick,onSetting,published,enable } = this.props;
    let content = [];
    content.push(<div>
      <Row className='rule-operate-row'>
        <Col span={12} style={{ height: '57px' }} >
          <div className='rule-operate-cell'>
            <Switch
              className="obj-publish-switch"
              onLabel="已发布"
              offLabel="调试中"
              onChange={togglePublish}
              onOff={published}
            />
          </div>
        </Col>
        <Col span={12} style={{ height: '57px' }} >
          <div className='rule-operate-cell-right'>
            <Switch
              className="obj-startuse-switch"
              onLabel="已启用"
              offLabel="未启用"
              onChange={toggleUse}
              onOff={enable}
            />
          </div>
        </Col>
      </Row>
      <Row className='rule-operate-row'>
        <Col span={12}>
          <div className='rule-operate-cell' onClick={onSetting} >编辑</div>
        </Col>
        <Col span={12}>
          <div className='rule-operate-cell-right' onClick={onDoubleClick} >查看</div>
        </Col>
      </Row>
      <Row className='rule-operate-row'>
        <Col span={12}>
          <div className='rule-operate-cell' onClick={this.deleteRule} >删除</div>
        </Col>
        <Col span={12}>
          <div className='rule-operate-cell-right' />
        </Col>
      </Row>
      <Row className='rule-operate-row'>
        <Col span={24}>
          <div className='rule-operate-cell-right' />
        </Col>
      </Row>
    </div>);
    return content;
  }

  deleteRule = () => {
    let { onRemove } = this.props;
    Modal.confirm({
      title: '批量删除',
      content: '是否删除所选信息？',
      okText: '确定',
      cancelText: '取消',
      onOk() {onRemove();},
      onCancel() {}
    });
  }

  render() {
    const { title, enable, published, onDoubleClick, showClose, showSetting,descr } = this.props;
    const isActive = enable || published;
    const _class = classnames('rule-lib-item', {
      'obj-item-used': isActive
    });

    return (
      <div tabIndex={'0'} onDoubleClick={onDoubleClick} className={_class}>
        <div className="rule-lib-item-title t-o">
          {title}
        </div>
        <div className="rule-lib-item-content-root">
          <div className="rule-lib-item-content">
            <div className="item-photo-wrapper">
              <div className="item-photo-inner" />
            </div>
            <div className="rule-lib-item-descr">{`描述：${descr}`}</div>
          </div>
          <div className="rule-lib-item-operate">
            {this.renderRuleOperate()}
          </div>
        </div>
      </div>
    );
  }
}

export default LibItem;
