import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Spin } from 'amos-framework';
import { AmosPlumb, stopEvent,setting } from 'amos-jsplumb';
import { jsPlumbOptions } from './modelConf/plumbOptions';
import getComponent from './elelist';


/**
 * 场景(画布)
 *
 * @class RuleScene
 * @extends {Component}
 */
class RuleScene extends Component {

  static propTypes = {
    zoom: PropTypes.number,
    dataSource: PropTypes.object,
    handleDrop: PropTypes.func,
    onPlumbChange: PropTypes.func,
    onSceneCreated: PropTypes.func,
    onPlumbClick: PropTypes.func,
    destroy: PropTypes.bool,
    eventListeners: PropTypes.object,
    onAddConnection:PropTypes.func,
    onRemoveConnection:PropTypes.func,
    onRemoveNode:PropTypes.func,
    onZoom:PropTypes.func,
    newRestProps: PropTypes.object
  };

  /**
   *
   * 这保证 handleDrop可以被调用
   * @memberOf RuleScene
   */
  handleDragOver = (event) => {
    stopEvent(event);
  }
  
  render() {
    const { defaultSettings, dottedConnectionStyle, selectedConnectionStyle } = setting;
    const registerTypes = {
      connections: {
        dotted: dottedConnectionStyle,
        selected: selectedConnectionStyle
      },
      endpoints: {}
    };
    const { zoom, handleDrop, onPlumbChange, onSceneCreated, destroy, onPlumbClick, 
      eventListeners,onAddConnection,onRemoveConnection,onRemoveNode,onZoom,newRestProps,nodeProps } = this.props;
    const {nodes,connections} = this.props.dataSource;  
    return (
      <div
        className="rule-scene"
        onDragOver={this.handleDragOver}
        onDrop={handleDrop}
      >
        <Spin type="grid" loading={destroy} color="#26A65B" className="grid-loading" />
        <AmosPlumb
          className="amos-plumb-container"
          key="amos-plumb"
          onAddConnection={onAddConnection}
          onRemoveConnection={onRemoveConnection}
          onRemoveNode={onRemoveNode}
          jsPlumbSettings={defaultSettings}
          registerTypes={registerTypes}
          onChange={onPlumbChange}
          onCreated={onSceneCreated}
          connections={connections}
	        nodes={nodes}
          onPlumbClick={onPlumbClick}
          eventListeners={eventListeners}
          zoom={zoom}
          nodeProps={nodeProps}
          onZoom={onZoom}
          showControl
          getNodeContent={getComponent}
          destroy={destroy}
          draggableOptions={{
          constrain: true
          }}
          {...newRestProps}
        />
      </div>
    );
  }
}

export default RuleScene;
