import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';
import { Animate } from 'amos-framework';
import classNames from 'classnames';

/**
 * 触发器编辑器外层容器
 *
 * @class TriggerEditor
 * @extends {Component}
 */
class TriggerEditor extends Component {

  constructor(props) {
    super(props);
    this.state = {
      expanded: props.expanded
    };
  }

  componentWillReceiveProps(nextProps) {
    this.setState({
      expanded: nextProps.expanded
    });
  }

  onClosed = () => {
    this.setState({
      expanded: false
    }, () => this.props.closeDesigner());
  }

  render() {
    const { expanded } = this.state;
    const { children } = this.props;

    const editorCls = classNames({
      'trigger-editor-content': true,
      'expanded': expanded
    });

    const icon = expanded ? 'right' : 'left';

    return (
      <Animate
        transitionName="slide-right"
        showProp="data-expand"
        transitionAppear
      >
        <div className="trigger-editor" data-expand={expanded}>
          <div
            className={editorCls}
          >
            {children}
          </div>
          {
            expanded &&
            <div className="slider-right" onClick={this.onClosed}>
              <Icon icon={icon} />
            </div>
          }
        </div>
      </Animate>
    );
  }
}

TriggerEditor.propTypes = {
  children: PropTypes.node,
  closeDesigner: PropTypes.func,
  expanded: PropTypes.bool
};

TriggerEditor.defaultProps = {
  closeDesigner(){},
  expanded: false
};

export default TriggerEditor;
